/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool.bpmn;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.UserTask;
import org.jbpm.simulation.util.BPMN2Utils;
import org.jsoup.parser.Parser;
import org.kie.workbench.common.forms.jbpm.model.authoring.process.BusinessProcessFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.migration.tool.bpmn.BPMNProcess;

public class BPMNAnalyzer {
    public BPMNProcess read(InputStream inputStream) {
        Definitions definitions = BPMN2Utils.getDefinitions((InputStream)inputStream);
        Optional<Process> processOptional = this.findProcess(definitions);
        if (!processOptional.isPresent()) {
            throw new RuntimeException("Cannot find Process on definitions");
        }
        Process process = processOptional.get();
        BusinessProcessFormModel formModel = new BusinessProcessFormModel(process.getId(), process.getName(), new ArrayList());
        BPMNProcess bpmmProcess = new BPMNProcess(formModel);
        this.readContainerUserTasks((FlowElementsContainer)process, bpmmProcess::addTaskFormModel);
        return bpmmProcess;
    }

    private void readContainerUserTasks(FlowElementsContainer container, Consumer<TaskFormModel> consumer) {
        container.getFlowElements().stream().filter(flowElement -> flowElement instanceof UserTask).map(flowElement -> (UserTask)flowElement).forEach(userTask -> this.readUserTask((UserTask)userTask, consumer));
        container.getFlowElements().stream().filter(flowElement -> flowElement instanceof FlowElementsContainer).map(flowElement -> (FlowElementsContainer)flowElement).forEach(flowElementsContainer -> this.readContainerUserTasks((FlowElementsContainer)flowElementsContainer, consumer));
    }

    private void readUserTask(UserTask userTask, Consumer<TaskFormModel> consumer) {
        userTask.getDataInputAssociations().stream().filter(inputAssociation -> inputAssociation.getTargetRef() != null && "TaskName".equals(((DataInput)inputAssociation.getTargetRef()).getName())).findAny().ifPresent(inputAssociation -> consumer.accept(new TaskFormModel("", this.readTaskFormName((DataInputAssociation)inputAssociation), new ArrayList())));
    }

    private String readTaskFormName(DataInputAssociation inputAssociation) {
        Optional<FormalExpression> optional = inputAssociation.getAssignment().stream().filter(assignment -> assignment.getFrom() != null && assignment.getFrom() instanceof FormalExpression).map(assignment -> (FormalExpression)assignment.getFrom()).findAny();
        if (optional.isPresent()) {
            return Parser.xmlParser().parseInput(optional.get().getBody(), "").toString();
        }
        return "";
    }

    private Optional<Process> findProcess(Definitions definitions) {
        return definitions.getRootElements().stream().filter(rootElement -> rootElement instanceof Process).map(rootElement -> (Process)rootElement).findAny();
    }
}

