/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.migration.cli.maven;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.kie.workbench.common.migration.cli.MigrationServicesCDIWrapper;
import org.kie.workbench.common.services.backend.pom.PomEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

public class PomMigrationEditor {
    private final Logger logger = LoggerFactory.getLogger(PomMigrationEditor.class);
    private PomEditor pomEditor = new PomEditor();
    private MavenXpp3Writer writer = new MavenXpp3Writer();

    public Model updatePom(Path pom, MigrationServicesCDIWrapper cdiWrapper) {
        try {
            Model model = this.pomEditor.updatePomWithoutWrite(pom);
            boolean written = this.write(model, pom, cdiWrapper);
            if (written) {
                return model;
            }
            return new Model();
        }
        catch (Exception e) {
            System.err.println("Error occurred during POMs migration:" + e.getMessage());
            this.logger.error(e.getMessage());
            return new Model();
        }
    }

    public Model updatePom(Path pom, String pathJsonFile, MigrationServicesCDIWrapper cdiWrapper) {
        try {
            Model model = this.pomEditor.updatePomWithoutWrite(pom, pathJsonFile);
            boolean written = this.write(model, pom, cdiWrapper);
            if (written) {
                return model;
            }
            return new Model();
        }
        catch (Exception e) {
            System.err.println("Error occurred during POMs migration:" + e.getMessage());
            this.logger.error(e.getMessage());
            return new Model();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Model model, Path path, MigrationServicesCDIWrapper cdiWrapper) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writer.write((OutputStream)baos, model);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Pom changed of the groupID:{} artifactID:{}:\n{}", new Object[]{model.getGroupId(), model.getArtifactId(), new String(baos.toByteArray(), StandardCharsets.UTF_8)});
            }
            cdiWrapper.write(Paths.convert((Path)path), new String(baos.toByteArray(), StandardCharsets.UTF_8), "Pom's Migration" + path.toString());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

