/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.common;

import java.io.IOException;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortUtil {
    private static final String ERROR_MESSAGE = "Error trying to find a free port.";
    private static final Logger LOG = LoggerFactory.getLogger(PortUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int validateOrGetNew(int preferredPort) {
        if (preferredPort != 0) {
            if (!PortUtil.isPortInUse(preferredPort)) return preferredPort;
        }
        if (preferredPort != 0) {
            LOG.warn("Port {} already in use, system will automatically look for a new one.", (Object)preferredPort);
        }
        try (ServerSocket ss = new ServerSocket(0);){
            int n = ss.getLocalPort();
            return n;
        }
        catch (IOException e) {
            LOG.error(ERROR_MESSAGE, (Throwable)e);
            throw new RuntimeException(ERROR_MESSAGE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortInUse(int port) {
        try (ServerSocket ss = new ServerSocket(port);){
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

