/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jgit.internal.storage.reftree.Command;
import org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class ConvertRefTree {
    private final Git git;
    private String txnNamespace;
    private String txnCommitted;

    public ConvertRefTree(Git git) {
        this.git = git;
    }

    public void execute() throws IOException {
        try (ObjectReader reader = this.git.getRepository().newObjectReader();
             RevWalk rw = new RevWalk(reader);
             ObjectInserter inserter = this.git.getRepository().newObjectInserter();){
            ObjectId oldTreeId;
            RefTreeDatabase d;
            RefDatabase refDb = this.git.getRepository().getRefDatabase();
            if (refDb instanceof RefTreeDatabase) {
                d = (RefTreeDatabase)refDb;
                refDb = d.getBootstrap();
                this.txnNamespace = d.getTxnNamespace();
                this.txnCommitted = d.getTxnCommitted();
            } else {
                d = new RefTreeDatabase(this.git.getRepository(), refDb);
                this.txnNamespace = d.getTxnNamespace();
                this.txnCommitted = d.getTxnCommitted();
            }
            CommitBuilder b = new CommitBuilder();
            Ref ref = refDb.exactRef(this.txnCommitted);
            RefUpdate update = refDb.newUpdate(this.txnCommitted, true);
            if (ref != null && ref.getObjectId() != null) {
                ObjectId oldId = ref.getObjectId();
                update.setExpectedOldObjectId((AnyObjectId)oldId);
                b.setParentId((AnyObjectId)oldId);
                oldTreeId = rw.parseCommit((AnyObjectId)oldId).getTree();
            } else {
                update.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
                oldTreeId = ObjectId.zeroId();
            }
            RefTree tree = this.rebuild(refDb);
            b.setTreeId((AnyObjectId)tree.writeTree(inserter));
            b.setAuthor(new PersonIdent("system", "system", new Date(1481754897254L), TimeZone.getDefault()));
            b.setCommitter(b.getAuthor());
            if (b.getTreeId().equals((AnyObjectId)oldTreeId)) {
                return;
            }
            update.setNewObjectId((AnyObjectId)inserter.insert(b));
            inserter.flush();
            RefUpdate.Result result = update.update(rw);
            switch (result) {
                case NEW: 
                case FAST_FORWARD: {
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("%s: %s", update.getName(), result));
                }
            }
            if (!(this.git.getRepository().getRefDatabase() instanceof RefTreeDatabase)) {
                StoredConfig cfg = this.git.getRepository().getConfig();
                cfg.setInt("core", null, "repositoryformatversion", 1);
                cfg.setString("extensions", null, "refsStorage", "reftree");
                cfg.save();
                Repository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.git.getRepository().getDirectory())).build();
                this.git.updateRepo(repo);
            }
            File commited = new File(this.git.getRepository().getDirectory(), this.txnCommitted);
            File accepted = new File(this.git.getRepository().getDirectory(), this.txnNamespace + "accepted");
            Files.copy(commited.toPath(), accepted.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private RefTree rebuild(RefDatabase refdb) throws IOException {
        RefTree tree = RefTree.newEmptyTree();
        ArrayList<Command> cmds = new ArrayList<Command>();
        Ref head = refdb.exactRef("HEAD");
        if (head != null) {
            cmds.add(new Command(null, head));
        }
        for (Ref r : refdb.getRefs("").values()) {
            if (r.getName().equals(this.txnCommitted) || r.getName().equals("HEAD") || r.getName().startsWith(this.txnNamespace)) continue;
            cmds.add(new Command(null, this.git.getRepository().peel(r)));
        }
        tree.apply(cmds);
        return tree;
    }
}

