/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.BranchUtil;
import org.uberfire.java.nio.fs.jgit.util.model.MergeCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.MessageCommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.RevertCommitContent;

public class RevertMerge {
    private final Git git;
    private final String sourceBranch;
    private final String targetBranch;
    private final String commonAncestorCommitId;
    private final String mergeCommitId;

    public RevertMerge(Git git, String sourceBranch, String targetBranch, String commonAncestorCommitId, String mergeCommitId) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.sourceBranch = PortablePreconditions.checkNotEmpty((String)"sourceBranch", (String)sourceBranch);
        this.targetBranch = PortablePreconditions.checkNotEmpty((String)"targetBranch", (String)targetBranch);
        this.commonAncestorCommitId = PortablePreconditions.checkNotEmpty((String)"commonAncestorCommitId", (String)commonAncestorCommitId);
        this.mergeCommitId = PortablePreconditions.checkNotEmpty((String)"mergeCommitId", (String)mergeCommitId);
    }

    public boolean execute() {
        BranchUtil.existsBranch(this.git, this.sourceBranch);
        BranchUtil.existsBranch(this.git, this.targetBranch);
        RevCommit lastSourceCommit = this.git.getLastCommit(this.sourceBranch);
        RevCommit lastTargetCommit = this.git.getLastCommit(this.targetBranch);
        boolean isDone = false;
        if (this.canRevert(lastSourceCommit, lastTargetCommit)) {
            this.git.commit(this.targetBranch, MessageCommitInfo.createRevertMergeMessage(this.sourceBranch), false, (ObjectId)lastTargetCommit.getParent(0), new RevertCommitContent(this.targetBranch));
            RevCommit newLastTargetCommit = this.git.getLastCommit(this.targetBranch);
            List<RevCommit> parents = Stream.of(lastSourceCommit, newLastTargetCommit).collect(Collectors.toList());
            Map<String, File> contents = this.git.mapDiffContent(this.targetBranch, lastTargetCommit.getName(), newLastTargetCommit.getName());
            this.git.commit(this.sourceBranch, MessageCommitInfo.createMergeMessage(this.targetBranch), false, (ObjectId)lastSourceCommit, new MergeCommitContent(contents, parents));
            this.git.commit(this.sourceBranch, MessageCommitInfo.createFixMergeReversionMessage(), false, (ObjectId)this.git.getLastCommit(this.sourceBranch).getParent(0), new RevertCommitContent(this.sourceBranch));
            isDone = true;
        }
        return isDone;
    }

    private boolean canRevert(RevCommit lastSourceCommit, RevCommit lastTargetCommit) {
        return lastTargetCommit.getParentCount() > 1 && lastTargetCommit.getName().equals(this.mergeCommitId) && lastTargetCommit.getParent(0).getName().equals(this.commonAncestorCommitId) && lastTargetCommit.getParent(1).getName().equals(lastSourceCommit.getName());
    }
}

