/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.ws.cluster;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.WatchEvent;

public class WatchEventsWrapper
implements Serializable {
    private final String nodeId;
    private final List<WatchEvent<?>> events;
    private final URI watchable;
    private final String fsName;

    public WatchEventsWrapper(String nodeId, String fsName, Path watchable, List<WatchEvent<?>> events) {
        this.nodeId = nodeId;
        this.fsName = fsName;
        this.events = events;
        this.watchable = watchable != null ? watchable.toUri() : null;
    }

    public String getFsName() {
        return this.fsName;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public List<WatchEvent<?>> getEvents() {
        return this.events;
    }

    public Path getWatchable() {
        if (this.watchable == null) {
            return null;
        }
        try {
            return Paths.get((URI)this.watchable);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchEventsWrapper that = (WatchEventsWrapper)o;
        if (this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null) {
            return false;
        }
        if (this.events != null ? !this.events.equals(that.events) : that.events != null) {
            return false;
        }
        if (this.watchable != null ? !this.watchable.equals(that.watchable) : that.watchable != null) {
            return false;
        }
        return this.fsName != null ? this.fsName.equals(that.fsName) : that.fsName == null;
    }

    public int hashCode() {
        int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        result = 31 * result + (this.watchable != null ? this.watchable.hashCode() : 0);
        result = 31 * result + (this.fsName != null ? this.fsName.hashCode() : 0);
        return result;
    }
}

