/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata;

import com.google.common.base.Preconditions;
import org.apache.lucene.analysis.Analyzer;
import org.uberfire.ext.metadata.MetadataConfig;
import org.uberfire.ext.metadata.backend.elastic.search.ElasticSearchSearchIndex;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.ext.metadata.search.SearchIndex;

public class ElasticSearchConfig
implements MetadataConfig {
    private final SearchIndex searchIndex;
    private final MetaIndexEngine metaIndexEngine;
    private final MetaModelStore metaModelStore;
    private final IndexProvider indexProvider;

    public ElasticSearchConfig(MetaIndexEngine metaIndexEngine, MetaModelStore metaModelStore, IndexProvider indexProvider, Analyzer analyzer) {
        this.metaModelStore = (MetaModelStore)Preconditions.checkNotNull((Object)metaModelStore, (Object)"metaModelStore");
        this.indexProvider = (IndexProvider)Preconditions.checkNotNull((Object)indexProvider, (Object)"indexProvider");
        this.searchIndex = new ElasticSearchSearchIndex(indexProvider, analyzer);
        this.metaIndexEngine = metaIndexEngine;
    }

    public SearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    public MetaIndexEngine getIndexEngine() {
        return this.metaIndexEngine;
    }

    public MetaModelStore getMetaModelStore() {
        return this.metaModelStore;
    }

    public int priority() {
        return -20;
    }

    public void dispose() {
    }

    public IndexProvider getIndexProvider() {
        return this.indexProvider;
    }
}

