/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextPostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

class SimpleTextFieldsReader
extends FieldsProducer {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextFieldsReader.class) + RamUsageEstimator.shallowSizeOfInstance(TreeMap.class);
    private final TreeMap<String, Long> fields;
    private final IndexInput in;
    private final FieldInfos fieldInfos;
    private final int maxDoc;
    private static final long TERMS_BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextTerms.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + RamUsageEstimator.shallowSizeOfInstance(CharsRef.class);
    private final Map<String, SimpleTextTerms> termsCache = new HashMap<String, SimpleTextTerms>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleTextFieldsReader(SegmentReadState state) throws IOException {
        this.maxDoc = state.segmentInfo.maxDoc();
        this.fieldInfos = state.fieldInfos;
        this.in = state.directory.openInput(SimpleTextPostingsFormat.getPostingsFileName(state.segmentInfo.name, state.segmentSuffix), state.context);
        boolean success = false;
        try {
            this.fields = this.readFields(this.in.clone());
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    private TreeMap<String, Long> readFields(IndexInput in) throws IOException {
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(in);
        BytesRefBuilder scratch = new BytesRefBuilder();
        TreeMap<String, Long> fields = new TreeMap<String, Long>();
        while (true) {
            SimpleTextUtil.readLine((DataInput)input, scratch);
            if (scratch.get().equals((Object)SimpleTextFieldsWriter.END)) {
                SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
                return fields;
            }
            if (!StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SimpleTextFieldsWriter.FIELD)) continue;
            String fieldName = new String(scratch.bytes(), SimpleTextFieldsWriter.FIELD.length, scratch.length() - SimpleTextFieldsWriter.FIELD.length, StandardCharsets.UTF_8);
            fields.put(fieldName, input.getFilePointer());
        }
    }

    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    public synchronized Terms terms(String field) throws IOException {
        SimpleTextTerms terms = this.termsCache.get(field);
        if (terms == null) {
            Long fp = this.fields.get(field);
            if (fp == null) {
                return null;
            }
            terms = new SimpleTextTerms(field, fp, this.maxDoc);
            this.termsCache.put(field, terms);
        }
        return terms;
    }

    public int size() {
        return -1;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized long ramBytesUsed() {
        long sizeInBytes = BASE_RAM_BYTES_USED + (long)(this.fields.size() * 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        for (SimpleTextTerms simpleTextTerms : this.termsCache.values()) {
            sizeInBytes += simpleTextTerms != null ? simpleTextTerms.ramBytesUsed() : 0L;
        }
        return sizeInBytes;
    }

    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables((String)"field", this.termsCache);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.fields.size() + ")";
    }

    public void checkIntegrity() throws IOException {
    }

    private class SimpleTextTerms
    extends Terms
    implements Accountable {
        private final long termsStart;
        private final FieldInfo fieldInfo;
        private final int maxDoc;
        private long sumTotalTermFreq;
        private long sumDocFreq;
        private int docCount;
        private FST<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fst;
        private int termCount;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final CharsRefBuilder scratchUTF16 = new CharsRefBuilder();

        public SimpleTextTerms(String field, long termsStart, int maxDoc) throws IOException {
            this.maxDoc = maxDoc;
            this.termsStart = termsStart;
            this.fieldInfo = SimpleTextFieldsReader.this.fieldInfos.fieldInfo(field);
            this.loadTerms();
        }

        private void loadTerms() throws IOException {
            PositiveIntOutputs posIntOutputs = PositiveIntOutputs.getSingleton();
            PairOutputs outputsInner = new PairOutputs((Outputs)posIntOutputs, (Outputs)posIntOutputs);
            PairOutputs outputs = new PairOutputs((Outputs)posIntOutputs, (Outputs)outputsInner);
            Builder b = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
            IndexInput in = SimpleTextFieldsReader.this.in.clone();
            in.seek(this.termsStart);
            BytesRefBuilder lastTerm = new BytesRefBuilder();
            long lastDocsStart = -1L;
            int docFreq = 0;
            long totalTermFreq = 0L;
            FixedBitSet visitedDocs = new FixedBitSet(this.maxDoc);
            IntsRefBuilder scratchIntsRef = new IntsRefBuilder();
            while (true) {
                SimpleTextUtil.readLine((DataInput)in, this.scratch);
                if (this.scratch.get().equals((Object)SimpleTextFieldsWriter.END) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.FIELD)) {
                    if (lastDocsStart == -1L) break;
                    b.add(Util.toIntsRef((BytesRef)lastTerm.get(), (IntsRefBuilder)scratchIntsRef), (Object)outputs.newPair((Object)lastDocsStart, (Object)outputsInner.newPair((Object)docFreq, (Object)totalTermFreq)));
                    this.sumTotalTermFreq += totalTermFreq;
                    break;
                }
                if (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.DOC)) {
                    ++docFreq;
                    ++this.sumDocFreq;
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.DOC.length, this.scratch.length() - SimpleTextFieldsWriter.DOC.length);
                    int docID = ArrayUtil.parseInt((char[])this.scratchUTF16.chars(), (int)0, (int)this.scratchUTF16.length());
                    visitedDocs.set(docID);
                    continue;
                }
                if (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.FREQ)) {
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.FREQ.length, this.scratch.length() - SimpleTextFieldsWriter.FREQ.length);
                    totalTermFreq += (long)ArrayUtil.parseInt((char[])this.scratchUTF16.chars(), (int)0, (int)this.scratchUTF16.length());
                    continue;
                }
                if (!StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.TERM)) continue;
                if (lastDocsStart != -1L) {
                    b.add(Util.toIntsRef((BytesRef)lastTerm.get(), (IntsRefBuilder)scratchIntsRef), (Object)outputs.newPair((Object)lastDocsStart, (Object)outputsInner.newPair((Object)docFreq, (Object)totalTermFreq)));
                }
                lastDocsStart = in.getFilePointer();
                int len = this.scratch.length() - SimpleTextFieldsWriter.TERM.length;
                lastTerm.grow(len);
                System.arraycopy(this.scratch.bytes(), SimpleTextFieldsWriter.TERM.length, lastTerm.bytes(), 0, len);
                lastTerm.setLength(len);
                docFreq = 0;
                this.sumTotalTermFreq += totalTermFreq;
                totalTermFreq = 0L;
                ++this.termCount;
            }
            this.docCount = visitedDocs.cardinality();
            this.fst = b.finish();
        }

        public long ramBytesUsed() {
            return TERMS_BASE_RAM_BYTES_USED + (this.fst != null ? this.fst.ramBytesUsed() : 0L) + RamUsageEstimator.sizeOf((byte[])this.scratch.bytes()) + RamUsageEstimator.sizeOf((char[])this.scratchUTF16.chars());
        }

        public Collection<Accountable> getChildResources() {
            if (this.fst == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Accountables.namedAccountable((String)"term cache", this.fst));
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(terms=" + this.termCount + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
        }

        public TermsEnum iterator() throws IOException {
            if (this.fst != null) {
                return new SimpleTextTermsEnum(this.fst, this.fieldInfo.getIndexOptions());
            }
            return TermsEnum.EMPTY;
        }

        public long size() {
            return this.termCount;
        }

        public long getSumTotalTermFreq() {
            return this.fieldInfo.getIndexOptions() == IndexOptions.DOCS ? -1L : this.sumTotalTermFreq;
        }

        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        public int getDocCount() throws IOException {
            return this.docCount;
        }

        public boolean hasFreqs() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        public boolean hasOffsets() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public boolean hasPositions() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        public boolean hasPayloads() {
            return this.fieldInfo.hasPayloads();
        }
    }

    static class TermData {
        public long docsStart;
        public int docFreq;

        public TermData(long docsStart, int docFreq) {
            this.docsStart = docsStart;
            this.docFreq = docFreq;
        }
    }

    private class SimpleTextPostingsEnum
    extends PostingsEnum {
        private final IndexInput inStart;
        private final IndexInput in;
        private int docID = -1;
        private int tf;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final BytesRefBuilder scratch2 = new BytesRefBuilder();
        private final CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
        private final CharsRefBuilder scratchUTF16_2 = new CharsRefBuilder();
        private int pos;
        private BytesRef payload;
        private long nextDocStart;
        private boolean readOffsets;
        private boolean readPositions;
        private int startOffset;
        private int endOffset;
        private int cost;

        public SimpleTextPostingsEnum() {
            this.inStart = SimpleTextFieldsReader.this.in;
            this.in = this.inStart.clone();
        }

        public boolean canReuse(IndexInput in) {
            return in == this.inStart;
        }

        public SimpleTextPostingsEnum reset(long fp, IndexOptions indexOptions, int docFreq) {
            this.nextDocStart = fp;
            this.docID = -1;
            this.readPositions = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            boolean bl = this.readOffsets = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            if (!this.readOffsets) {
                this.startOffset = -1;
                this.endOffset = -1;
            }
            this.cost = docFreq;
            return this;
        }

        public int docID() {
            return this.docID;
        }

        public int freq() throws IOException {
            return this.tf;
        }

        public int nextDoc() throws IOException {
            long lineStart;
            boolean first = true;
            this.in.seek(this.nextDocStart);
            long posStart = 0L;
            while (true) {
                lineStart = this.in.getFilePointer();
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                if (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.DOC)) {
                    if (!first) {
                        this.nextDocStart = lineStart;
                        this.in.seek(posStart);
                        return this.docID;
                    }
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.DOC.length, this.scratch.length() - SimpleTextFieldsWriter.DOC.length);
                    this.docID = ArrayUtil.parseInt((char[])this.scratchUTF16.chars(), (int)0, (int)this.scratchUTF16.length());
                    this.tf = 0;
                    first = false;
                    continue;
                }
                if (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.FREQ)) {
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.FREQ.length, this.scratch.length() - SimpleTextFieldsWriter.FREQ.length);
                    this.tf = ArrayUtil.parseInt((char[])this.scratchUTF16.chars(), (int)0, (int)this.scratchUTF16.length());
                    posStart = this.in.getFilePointer();
                    continue;
                }
                if (!(StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.POS) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.START_OFFSET) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.END_OFFSET) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.PAYLOAD))) break;
            }
            assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.TERM) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.FIELD) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.END));
            if (!first) {
                this.nextDocStart = lineStart;
                this.in.seek(posStart);
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public int nextPosition() throws IOException {
            if (this.readPositions) {
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.POS)) : "got line=" + this.scratch.get().utf8ToString();
                this.scratchUTF16_2.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.POS.length, this.scratch.length() - SimpleTextFieldsWriter.POS.length);
                this.pos = ArrayUtil.parseInt((char[])this.scratchUTF16_2.chars(), (int)0, (int)this.scratchUTF16_2.length());
            } else {
                this.pos = -1;
            }
            if (this.readOffsets) {
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.START_OFFSET)) : "got line=" + this.scratch.get().utf8ToString();
                this.scratchUTF16_2.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.START_OFFSET.length, this.scratch.length() - SimpleTextFieldsWriter.START_OFFSET.length);
                this.startOffset = ArrayUtil.parseInt((char[])this.scratchUTF16_2.chars(), (int)0, (int)this.scratchUTF16_2.length());
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.END_OFFSET)) : "got line=" + this.scratch.get().utf8ToString();
                this.scratchUTF16_2.grow(this.scratch.length() - SimpleTextFieldsWriter.END_OFFSET.length);
                this.scratchUTF16_2.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.END_OFFSET.length, this.scratch.length() - SimpleTextFieldsWriter.END_OFFSET.length);
                this.endOffset = ArrayUtil.parseInt((char[])this.scratchUTF16_2.chars(), (int)0, (int)this.scratchUTF16_2.length());
            }
            long fp = this.in.getFilePointer();
            SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
            if (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.PAYLOAD)) {
                int len = this.scratch.length() - SimpleTextFieldsWriter.PAYLOAD.length;
                this.scratch2.grow(len);
                System.arraycopy(this.scratch.bytes(), SimpleTextFieldsWriter.PAYLOAD.length, this.scratch2.bytes(), 0, len);
                this.scratch2.setLength(len);
                this.payload = this.scratch2.get();
            } else {
                this.payload = null;
                this.in.seek(fp);
            }
            return this.pos;
        }

        public int startOffset() throws IOException {
            return this.startOffset;
        }

        public int endOffset() throws IOException {
            return this.endOffset;
        }

        public BytesRef getPayload() {
            return this.payload;
        }

        public long cost() {
            return this.cost;
        }
    }

    private class SimpleTextDocsEnum
    extends PostingsEnum {
        private final IndexInput inStart;
        private final IndexInput in;
        private boolean omitTF;
        private int docID = -1;
        private int tf;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
        private int cost;

        public SimpleTextDocsEnum() {
            this.inStart = SimpleTextFieldsReader.this.in;
            this.in = this.inStart.clone();
        }

        public boolean canReuse(IndexInput in) {
            return in == this.inStart;
        }

        public SimpleTextDocsEnum reset(long fp, boolean omitTF, int docFreq) throws IOException {
            this.in.seek(fp);
            this.omitTF = omitTF;
            this.docID = -1;
            this.tf = 1;
            this.cost = docFreq;
            return this;
        }

        public int docID() {
            return this.docID;
        }

        public int freq() throws IOException {
            return this.tf;
        }

        public int nextPosition() throws IOException {
            return -1;
        }

        public int startOffset() throws IOException {
            return -1;
        }

        public int endOffset() throws IOException {
            return -1;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }

        public int nextDoc() throws IOException {
            long lineStart;
            if (this.docID == Integer.MAX_VALUE) {
                return this.docID;
            }
            boolean first = true;
            int termFreq = 0;
            while (true) {
                lineStart = this.in.getFilePointer();
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                if (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.DOC)) {
                    if (!first) {
                        this.in.seek(lineStart);
                        if (!this.omitTF) {
                            this.tf = termFreq;
                        }
                        return this.docID;
                    }
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.DOC.length, this.scratch.length() - SimpleTextFieldsWriter.DOC.length);
                    this.docID = ArrayUtil.parseInt((char[])this.scratchUTF16.chars(), (int)0, (int)this.scratchUTF16.length());
                    termFreq = 0;
                    first = false;
                    continue;
                }
                if (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.FREQ)) {
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.FREQ.length, this.scratch.length() - SimpleTextFieldsWriter.FREQ.length);
                    termFreq = ArrayUtil.parseInt((char[])this.scratchUTF16.chars(), (int)0, (int)this.scratchUTF16.length());
                    continue;
                }
                if (!(StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.POS) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.START_OFFSET) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.END_OFFSET) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.PAYLOAD))) break;
            }
            assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.TERM) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.FIELD) || StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextFieldsWriter.END)) : "scratch=" + this.scratch.get().utf8ToString();
            if (!first) {
                this.in.seek(lineStart);
                if (!this.omitTF) {
                    this.tf = termFreq;
                }
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public long cost() {
            return this.cost;
        }
    }

    private class SimpleTextTermsEnum
    extends TermsEnum {
        private final IndexOptions indexOptions;
        private int docFreq;
        private long totalTermFreq;
        private long docsStart;
        private boolean ended;
        private final BytesRefFSTEnum<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fstEnum;

        public SimpleTextTermsEnum(FST<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fst, IndexOptions indexOptions) {
            this.indexOptions = indexOptions;
            this.fstEnum = new BytesRefFSTEnum(fst);
        }

        public boolean seekExact(BytesRef text) throws IOException {
            BytesRefFSTEnum.InputOutput result = this.fstEnum.seekExact(text);
            if (result != null) {
                PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
                PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
                this.docsStart = (Long)pair1.output1;
                this.docFreq = ((Long)pair2.output1).intValue();
                this.totalTermFreq = (Long)pair2.output2;
                return true;
            }
            return false;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            BytesRefFSTEnum.InputOutput result = this.fstEnum.seekCeil(text);
            if (result == null) {
                return TermsEnum.SeekStatus.END;
            }
            PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
            PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
            this.docsStart = (Long)pair1.output1;
            this.docFreq = ((Long)pair2.output1).intValue();
            this.totalTermFreq = (Long)pair2.output2;
            if (result.input.equals((Object)text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public BytesRef next() throws IOException {
            assert (!this.ended);
            BytesRefFSTEnum.InputOutput result = this.fstEnum.next();
            if (result != null) {
                PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
                PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
                this.docsStart = (Long)pair1.output1;
                this.docFreq = ((Long)pair2.output1).intValue();
                this.totalTermFreq = (Long)pair2.output2;
                return result.input;
            }
            return null;
        }

        public BytesRef term() {
            return this.fstEnum.current().input;
        }

        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seekExact(long ord) {
            throw new UnsupportedOperationException();
        }

        public int docFreq() {
            return this.docFreq;
        }

        public long totalTermFreq() {
            return this.indexOptions == IndexOptions.DOCS ? -1L : this.totalTermFreq;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            boolean hasPositions;
            boolean bl = hasPositions = this.indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            if (hasPositions && PostingsEnum.featureRequested((int)flags, (short)24)) {
                SimpleTextPostingsEnum docsAndPositionsEnum = reuse != null && reuse instanceof SimpleTextPostingsEnum && ((SimpleTextPostingsEnum)reuse).canReuse(SimpleTextFieldsReader.this.in) ? (SimpleTextPostingsEnum)reuse : new SimpleTextPostingsEnum();
                return docsAndPositionsEnum.reset(this.docsStart, this.indexOptions, this.docFreq);
            }
            SimpleTextDocsEnum docsEnum = reuse != null && reuse instanceof SimpleTextDocsEnum && ((SimpleTextDocsEnum)reuse).canReuse(SimpleTextFieldsReader.this.in) ? (SimpleTextDocsEnum)reuse : new SimpleTextDocsEnum();
            return docsEnum.reset(this.docsStart, this.indexOptions == IndexOptions.DOCS, this.docFreq);
        }
    }
}

