/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityLifecycleError;
import org.uberfire.client.workbench.widgets.notifications.NotificationManager;
import org.uberfire.debug.Debug;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class ActivityLifecycleErrorHandler {
    @Inject
    private Logger logger;
    @Inject
    private Event<ActivityLifecycleError> lifecycleErrorEvent;
    @Inject
    private NotificationManager notificationManager;
    private boolean errorHandlingInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Activity failedActivity, ActivityLifecycleError.LifecyclePhase failedCall, Throwable exception) {
        if (this.errorHandlingInProgress) {
            return;
        }
        try {
            this.errorHandlingInProgress = true;
            ActivityLifecycleError event = new ActivityLifecycleError(failedActivity, failedCall, exception);
            try {
                this.lifecycleErrorEvent.fire((Object)event);
            }
            catch (Exception ex) {
                this.logger.warn("A lifecycle error observer threw an exception", (Throwable)ex);
            }
            if (!event.isErrorMessageSuppressed()) {
                StringBuilder message = new StringBuilder();
                message.append(Debug.shortName(failedActivity.getClass()) + " failed in ").append((Object)failedCall);
                if (exception != null) {
                    message.append(": ").append(exception.toString());
                }
                this.notificationManager.addNotification(new NotificationEvent(message.toString(), NotificationEvent.NotificationType.ERROR));
            }
        }
        finally {
            this.errorHandlingInProgress = false;
        }
    }
}

