/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.workbench.panels.impl.AbstractWorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.UnanchoredStaticWorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.panel.StaticFocusedResizePanel;
import org.uberfire.workbench.model.PartDefinition;

@Dependent
@Named(value="UnanchoredStaticWorkbenchPanelView")
public class UnanchoredStaticWorkbenchPanelView
extends AbstractWorkbenchPanelView<UnanchoredStaticWorkbenchPanelPresenter> {
    @Inject
    PlaceManager placeManager;
    @Inject
    StaticFocusedResizePanel panel;

    @PostConstruct
    void postConstruct() {
        this.panel.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                UnanchoredStaticWorkbenchPanelView.this.panelManager.onPanelFocus(((UnanchoredStaticWorkbenchPanelPresenter)UnanchoredStaticWorkbenchPanelView.this.presenter).getDefinition());
            }
        });
        this.panel.addSelectionHandler(new SelectionHandler<PartDefinition>(){

            public void onSelection(SelectionEvent<PartDefinition> event) {
                UnanchoredStaticWorkbenchPanelView.this.panelManager.onPartLostFocus();
                UnanchoredStaticWorkbenchPanelView.this.panelManager.onPartFocus((PartDefinition)event.getSelectedItem());
            }
        });
        Layouts.setToFillParent((Widget)this.panel);
        this.initWidget((Widget)this.panel);
    }

    public Widget getWidget() {
        return this.panel;
    }

    public StaticFocusedResizePanel getPanel() {
        return this.panel;
    }

    public void init(UnanchoredStaticWorkbenchPanelPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public UnanchoredStaticWorkbenchPanelPresenter getPresenter() {
        return (UnanchoredStaticWorkbenchPanelPresenter)this.presenter;
    }

    @Override
    public void addPart(WorkbenchPartPresenter.View view) {
        if (this.panel.getPartView() != null) {
            throw new RuntimeException("Uberfire Panel Invalid State: This panel support only one part.");
        }
        this.panel.setPart(view);
        this.onResize();
    }

    @Override
    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
    }

    @Override
    public boolean selectPart(PartDefinition part) {
        PartDefinition currentPartDefinition = this.getCurrentPartDefinition();
        return currentPartDefinition != null && currentPartDefinition.equals(part);
    }

    @Override
    public boolean removePart(PartDefinition part) {
        PartDefinition currentPartDefinition = this.getCurrentPartDefinition();
        if (currentPartDefinition != null && currentPartDefinition.equals(part)) {
            this.panel.clear();
            return true;
        }
        return false;
    }

    @Override
    public void setFocus(boolean hasFocus) {
        this.panel.setFocus(hasFocus);
    }

    public void onResize() {
        ((UnanchoredStaticWorkbenchPanelPresenter)this.presenter).onResize(this.getOffsetWidth(), this.getOffsetHeight());
        super.onResize();
    }

    PartDefinition getCurrentPartDefinition() {
        WorkbenchPartPresenter.View partView = this.panel.getPartView();
        if (partView == null) {
            return null;
        }
        WorkbenchPartPresenter presenter = partView.getPresenter();
        if (presenter == null) {
            return null;
        }
        return presenter.getDefinition();
    }

    @Override
    public Collection<PartDefinition> getParts() {
        PartDefinition currentPartDefinition = this.getCurrentPartDefinition();
        if (currentPartDefinition == null) {
            return new ArrayList<PartDefinition>();
        }
        return Arrays.asList(currentPartDefinition);
    }
}

