/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.widgets.menu.HasMenus;
import org.uberfire.client.workbench.widgets.menu.MenuItemVisibilityHandler;
import org.uberfire.client.workbench.widgets.menu.base.WorkbenchBaseMenuView;
import org.uberfire.client.workbench.widgets.menu.events.PerspectiveVisibiltiyChangeEvent;
import org.uberfire.plugin.PluginUtil;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public abstract class WorkbenchBaseMenuPresenter
implements HasMenus {
    private List<MenuItemVisibilityHandler> visibilityHandlers;
    private List<Menus> addedMenus;

    protected abstract WorkbenchBaseMenuView getBaseView();

    protected abstract void visitMenus(Menus var1);

    public abstract void onPerspectiveChange(PerspectiveChange var1);

    @Override
    public void addMenus(Menus menus) {
        if (menus != null && !menus.getItems().isEmpty()) {
            if (this.addedMenus == null) {
                this.addedMenus = new ArrayList<Menus>();
            }
            if (this.visibilityHandlers == null) {
                this.visibilityHandlers = new ArrayList<MenuItemVisibilityHandler>();
            }
            this.addedMenus.add(menus);
            if (this.menusMustBeReordered(menus)) {
                this.reorderMenus();
                this.getBaseView().clear();
                for (Menus currentMenus : this.addedMenus) {
                    this.visitMenus(currentMenus);
                }
            } else {
                this.visitMenus(menus);
            }
        }
    }

    private boolean menusMustBeReordered(Menus menus) {
        if (this.addedMenus.size() < 2) {
            return false;
        }
        Menus previousMenus = this.addedMenus.get(this.addedMenus.size() - 2);
        return previousMenus.getOrder() > menus.getOrder();
    }

    private void reorderMenus() {
        Collections.sort(this.addedMenus, (o1, o2) -> o1.getOrder() - o2.getOrder());
    }

    public List<Menus> getAddedMenus() {
        return this.addedMenus;
    }

    protected void synchronizeUIWithMenus(List<MenuItem> menuItems) {
        for (MenuItem menuItem : PluginUtil.ensureIterable(menuItems)) {
            if (menuItem instanceof MenuGroup) {
                this.synchronizeUIWithMenus(((MenuGroup)menuItem).getItems());
                continue;
            }
            menuItem.setEnabled(menuItem.isEnabled());
        }
    }

    protected void registerVisibilityChangeHandler(MenuItemVisibilityHandler handler) {
        this.visibilityHandlers.add(handler);
    }

    public void onPerspectiveVisibilityChange(PerspectiveVisibiltiyChangeEvent event) {
        if (this.visibilityHandlers != null) {
            this.visibilityHandlers.stream().filter(handler -> handler.getIdentifier().equals(event.getPerspectiveId())).forEach(handler -> handler.run(event.isVisible()));
        }
    }
}

