/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu.megamenu.visitor;

import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.menu.base.WorkbenchBaseMenuUtils;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.impl.BaseMenuVisitor;

public class WorkbenchMegaMenuVisitor
extends BaseMenuVisitor {
    private WorkbenchMegaMenuPresenter presenter;
    private PerspectiveManager perspectiveManager;
    private PlaceManager placeManager;
    private String parentId = null;

    public WorkbenchMegaMenuVisitor(WorkbenchMegaMenuPresenter presenter, PerspectiveManager perspectiveManager, PlaceManager placeManager) {
        this.presenter = presenter;
        this.perspectiveManager = perspectiveManager;
        this.placeManager = placeManager;
    }

    public boolean visitEnter(MenuGroup menuGroup) {
        this.parentId = WorkbenchBaseMenuUtils.getMenuItemId((MenuItem)menuGroup);
        this.presenter.addGroupMenuItem(this.parentId, menuGroup.getCaption(), menuGroup.getPosition());
        return true;
    }

    public void visitLeave(MenuGroup menuGroup) {
        this.parentId = null;
    }

    public void visit(MenuItemPlain menuItemPlain) {
        this.presenter.addMenuItem(WorkbenchBaseMenuUtils.getMenuItemId((MenuItem)menuItemPlain), menuItemPlain.getCaption(), this.parentId, null, menuItemPlain.getPosition());
        this.setupEnableDisableMenuItem((MenuItem)menuItemPlain);
    }

    public void visit(MenuCustom<?> menuCustom) {
        this.presenter.addMenuItem(WorkbenchBaseMenuUtils.getMenuItemId(menuCustom), menuCustom.getCaption(), this.parentId, null, menuCustom.getPosition());
        this.setupEnableDisableMenuItem((MenuItem)menuCustom);
    }

    public void visit(MenuItemCommand menuItemCommand) {
        this.presenter.addMenuItem(WorkbenchBaseMenuUtils.getMenuItemId((MenuItem)menuItemCommand), menuItemCommand.getCaption(), this.parentId, menuItemCommand.getCommand(), menuItemCommand.getPosition());
        this.setupEnableDisableMenuItem((MenuItem)menuItemCommand);
    }

    public void visit(MenuItemPerspective menuItemPerspective) {
        String id = menuItemPerspective.getPlaceRequest().getIdentifier();
        this.presenter.addMenuItem(id, menuItemPerspective.getCaption(), this.parentId, () -> this.placeManager.goTo(menuItemPerspective.getPlaceRequest()), menuItemPerspective.getPosition());
        this.setupEnableDisableMenuItem((MenuItem)menuItemPerspective);
        this.presenter.setupSetVisibleMenuItem(menuItemPerspective);
        PlaceRequest placeRequest = menuItemPerspective.getPlaceRequest();
        if (this.perspectiveManager.getCurrentPerspective() != null && placeRequest.equals(this.perspectiveManager.getCurrentPerspective().getPlace())) {
            this.presenter.selectMenuItem(id);
        }
    }

    protected String getParentId() {
        return this.parentId;
    }

    protected void setParentId(String parentId) {
        this.parentId = parentId;
    }

    protected void setupEnableDisableMenuItem(MenuItem menuItem) {
        menuItem.addEnabledStateChangeListener(enabled -> this.presenter.enableMenuItem(WorkbenchBaseMenuUtils.getMenuItemId(menuItem), enabled));
    }
}

