/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.mocks;

import com.google.common.base.Defaults;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;

public class CallerProxy
implements InvocationHandler {
    private Object target;
    private RemoteCallback<Object> successCallBack;
    private ErrorCallback<Object> errorCallBack;

    private CallerProxy(Object target) {
        this.target = target;
    }

    static Object newInstance(Object target) {
        return Proxy.newProxyInstance(target.getClass().getClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)new CallerProxy(target));
    }

    public void setSuccessCallBack(RemoteCallback<Object> successCallBack) {
        this.successCallBack = successCallBack;
    }

    public void setErrorCallBack(ErrorCallback<Object> errorCallBack) {
        this.errorCallBack = errorCallBack;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        try {
            result = m.invoke(this.target, args);
        }
        catch (Exception e) {
            if (this.errorCallBack != null) {
                if (e instanceof InvocationTargetException) {
                    this.errorCallBack.error(result, ((InvocationTargetException)e).getTargetException());
                } else {
                    this.errorCallBack.error(result, (Throwable)e);
                }
            }
            if (m.getReturnType().isPrimitive()) {
                return Defaults.defaultValue(m.getReturnType());
            }
            return result;
        }
        if (this.successCallBack != null) {
            this.successCallBack.callback(result);
        }
        return result;
    }
}

