/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.keyboard;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String NAME = "keyboard-interactive";
    public static final String INTERACTIVE_LANGUAGE_TAG = "kb-client-interactive-language-tag";
    public static final String DEFAULT_INTERACTIVE_LANGUAGE_TAG = "";
    public static final String INTERACTIVE_SUBMETHODS = "kb-client-interactive-sub-methods";
    public static final String DEFAULT_INTERACTIVE_SUBMETHODS = "";
    private final AtomicBoolean requestPending = new AtomicBoolean(false);
    private final AtomicInteger trialsCount = new AtomicInteger(0);
    private Iterator<String> passwords;
    private int maxTrials;

    public UserAuthKeyboardInteractive() {
        super(NAME);
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.passwords = PasswordIdentityProvider.iteratorOf(session);
        this.maxTrials = session.getIntProperty("password-prompts", 3);
        ValidateUtils.checkTrue(this.maxTrials > 0, "Non-positive max. trials: %d", this.maxTrials);
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        String name = this.getName();
        if (this.requestPending.get()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAuthDataRequest({})[{}] no reply for previous request for {}", new Object[]{session, service, name});
            }
            return false;
        }
        if (!this.verifyTrialsCount(session, service, 50, this.trialsCount.get(), this.maxTrials)) {
            return false;
        }
        String username = session.getUsername();
        String lang = this.getExchangeLanguageTag(session);
        String subMethods = this.getExchangeSubMethods(session);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST for {}: lang={}, methods={}", new Object[]{session, service, name, lang, subMethods});
        }
        Buffer buffer = session.createBuffer((byte)50, username.length() + service.length() + name.length() + GenericUtils.length(lang) + GenericUtils.length(subMethods) + 64);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putString(lang);
        buffer.putString(subMethods);
        this.requestPending.set(true);
        session.writePacket(buffer);
        return true;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        String[] rep;
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "]" + " received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        this.requestPending.set(false);
        if (!this.verifyTrialsCount(session, service, cmd, this.trialsCount.incrementAndGet(), this.maxTrials)) {
            return false;
        }
        String name = buffer.getString();
        String instruction = buffer.getString();
        String lang = buffer.getString();
        int num = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("processAuthDataRequest({})[{}] SSH_MSG_USERAUTH_INFO_REQUEST name={}, instruction={}, language={}, num-prompts={}", new Object[]{session, service, name, instruction, lang, num});
        }
        Object[] prompt = new String[num];
        boolean[] echo = new boolean[num];
        for (int i = 0; i < num; ++i) {
            prompt[i] = buffer.getString();
            echo[i] = buffer.getBoolean();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("processAuthDataRequest({})[{}] Prompt: {}", new Object[]{session, service, Arrays.toString(prompt)});
            this.log.trace("processAuthDataRequest({})[{}] Echo: {}", new Object[]{session, service, Arrays.toString(echo)});
        }
        if ((rep = this.getUserResponses(name, instruction, lang, (String[])prompt, echo)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("processAuthDataRequest({})[{}] no responses for {}", new Object[]{session, service, name});
            }
            return false;
        }
        if (num != rep.length) {
            this.log.warn("processAuthDataRequest({})[{}] Mismatched prompts ({}) vs. responses count ({})", new Object[]{session, service, num, rep.length});
        }
        buffer = session.createBuffer((byte)61, rep.length * 64 + 8);
        buffer.putInt(rep.length);
        for (int index = 0; index < rep.length; ++index) {
            String r = rep[index];
            if (this.log.isTraceEnabled()) {
                this.log.trace("processAuthDataRequest({})[{}] response #{}: {}", new Object[]{session, service, index + 1, r});
            }
            buffer.putString(r);
        }
        session.writePacket(buffer);
        return true;
    }

    protected String getExchangeLanguageTag(ClientSession session) {
        return session.getStringProperty(INTERACTIVE_LANGUAGE_TAG, "");
    }

    protected String getExchangeSubMethods(ClientSession session) {
        return session.getStringProperty(INTERACTIVE_SUBMETHODS, "");
    }

    protected String getCurrentPasswordCandidate() {
        if (this.passwords != null && this.passwords.hasNext()) {
            return this.passwords.next();
        }
        return null;
    }

    protected boolean verifyTrialsCount(ClientSession session, String service, int cmd, int nbTrials, int maxAllowed) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("verifyTrialsCount({})[{}] cmd={} - {} out of {}", new Object[]{session, service, UserAuthKeyboardInteractive.getAuthCommandName(cmd), nbTrials, maxAllowed});
        }
        return nbTrials <= maxAllowed;
    }

    protected String[] getUserResponses(String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        ClientSession session = this.getClientSession();
        int num = GenericUtils.length(prompt);
        if (num == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("getUserResponses({}) no prompts for interaction={}", (Object)session, (Object)name);
            }
            return GenericUtils.EMPTY_STRING_ARRAY;
        }
        String candidate = this.getCurrentPasswordCandidate();
        if (this.useCurrentPassword(candidate, name, instruction, lang, prompt, echo)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("getUserResponses({}) use password candidate for interaction={}", (Object)session, (Object)name);
            }
            return new String[]{candidate};
        }
        UserInteraction ui = session.getUserInteraction();
        try {
            if (ui != null && ui.isInteractionAllowed(session)) {
                return ui.interactive(session, name, instruction, lang, prompt, echo);
            }
        }
        catch (Error e) {
            this.log.warn("getUserResponses({}) failed ({}) to consult interaction: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("getUserResponses(" + session + ") interaction consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getUserResponses({}) no user interaction for name={}", (Object)session, (Object)name);
        }
        return null;
    }

    protected boolean useCurrentPassword(String password, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        int num = GenericUtils.length(prompt);
        if (num != 1 || password == null || echo[0]) {
            return false;
        }
        String value = GenericUtils.trimToEmpty(prompt[0]).toLowerCase();
        int passPos = value.lastIndexOf("password");
        if (passPos < 0) {
            return false;
        }
        int sepPos = value.lastIndexOf(58);
        return sepPos > passPos;
    }

    public static String getAuthCommandName(int cmd) {
        switch (cmd) {
            case 50: {
                return "SSH_MSG_USERAUTH_REQUEST";
            }
            case 60: {
                return "SSH_MSG_USERAUTH_INFO_REQUEST";
            }
        }
        return SshConstants.getCommandMessageName(cmd);
    }
}

