/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.services.backend.serialization.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.model.MetaDataEntry;
import org.kie.workbench.common.forms.model.ModelMetaData;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.kie.workbench.common.forms.model.impl.ModelPropertyImpl;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;
import org.kie.workbench.common.forms.model.impl.meta.ModelMetaDataImpl;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FieldSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormModelSerializer;

@Dependent
public class FormDefinitionSerializerImpl
implements FormDefinitionSerializer {
    private FieldSerializer fieldSerializer;
    private FormModelSerializer formModelSerializer;
    private MetaDataEntryManager metaDataEntryManager;

    @Inject
    public FormDefinitionSerializerImpl(FieldSerializer fieldSerializer, FormModelSerializer formModelSerializer, MetaDataEntryManager metaDataEntryManager) {
        this.fieldSerializer = fieldSerializer;
        this.formModelSerializer = formModelSerializer;
        this.metaDataEntryManager = metaDataEntryManager;
    }

    @Override
    public String serialize(FormDefinition form) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(FormModel.class, (Object)this.formModelSerializer);
        builder.registerTypeAdapter(FieldDefinition.class, (Object)this.fieldSerializer);
        Gson gson = builder.create();
        return gson.toJson((Object)form);
    }

    @Override
    public FormDefinition deserialize(String serializedForm) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(FormModel.class, (Object)this.formModelSerializer);
        builder.registerTypeAdapter(FieldDefinition.class, (Object)this.fieldSerializer);
        builder.registerTypeAdapter(ModelProperty.class, (json, typeOfT, context) -> (ModelProperty)context.deserialize(json, ModelPropertyImpl.class));
        builder.registerTypeAdapter(TypeInfo.class, (json, typeOfT, context) -> (TypeInfo)context.deserialize(json, TypeInfoImpl.class));
        builder.registerTypeAdapter(ModelMetaData.class, (json, typeOfT, context) -> (ModelMetaData)context.deserialize(json, ModelMetaDataImpl.class));
        builder.registerTypeAdapter(MetaDataEntry.class, (json, typeOfT, context) -> {
            JsonObject jsonField = json.getAsJsonObject();
            JsonElement jsonName = jsonField.get("name");
            return (MetaDataEntry)context.deserialize(json, (Type)this.metaDataEntryManager.getMetaDataEntryClass(jsonName.getAsString()));
        });
        Gson gson = builder.create();
        return (FormDefinition)gson.fromJson(serializedForm, FormDefinition.class);
    }
}

