/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.variable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.core.TypeObject;
import org.jbpm.process.core.ValueObject;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.UndefinedDataType;

public class Variable
implements TypeObject,
ValueObject,
Serializable {
    private static final long serialVersionUID = 510L;
    public static final String VARIABLE_TAGS = "customTags";
    public static final String READONLY_TAG = "readonly";
    public static final String REQUIRED_TAG = "required";
    private String name;
    private DataType type;
    private Object value;
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private List<String> tags = new ArrayList<String>();

    public Variable() {
        this.type = UndefinedDataType.getInstance();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public void setType(DataType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (!this.type.verifyDataType(value)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value <");
            sb.append(value);
            sb.append("> is not valid for datatype: ");
            sb.append(this.type);
            throw new IllegalArgumentException(sb.toString());
        }
        this.value = value;
    }

    public void setMetaData(String name, Object value) {
        this.metaData.put(name, value);
        if (VARIABLE_TAGS.equals(name) && value != null) {
            this.tags = Arrays.asList(value.toString().split(","));
        }
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public String toString() {
        return this.name;
    }

    public List<String> getTags() {
        if (this.tags.isEmpty() && this.metaData.containsKey(VARIABLE_TAGS)) {
            this.tags = Arrays.asList(this.metaData.get(VARIABLE_TAGS).toString().split(","));
        }
        return this.tags;
    }

    public boolean hasTag(String tagName) {
        return this.getTags().contains(tagName);
    }
}

