/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.servlet;

import java.util.Set;
import javax.inject.Inject;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.server.BaseFilteredServlet;

@WebServlet(name="ReleaseUserLocksServlet", urlPatterns={"/releaseUserLocksServlet"})
public class ReleaseUserLocksServlet
extends BaseFilteredServlet {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseUserLocksServlet.class);
    @Inject
    private VFSLockService vfsLockService;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        if (session != null && session.getAttribute("uf-locks") != null) {
            Set locks = (Set)session.getAttribute("uf-locks");
            try {
                locks.forEach(lockInfo -> this.vfsLockService.releaseLock(lockInfo.getFile()));
                locks.clear();
            }
            catch (Exception e) {
                logger.error("Error when releasing locks.", (Throwable)e);
            }
        }
    }
}

