/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.backend;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.annotations.Customizable;
import org.uberfire.preferences.backend.annotations.ComponentKey;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceScopeResolver;
import org.uberfire.preferences.shared.PreferenceStorage;
import org.uberfire.preferences.shared.PreferenceStore;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.preferences.shared.impl.PreferenceScopedValue;

@Service
public class PreferenceStoreImpl
implements PreferenceStore {
    protected PreferenceStorage storage;
    protected PreferenceScopeResolutionStrategy defaultScopeResolutionStrategy;
    protected PreferenceScopeFactory scopeFactory;

    protected PreferenceStoreImpl() {
    }

    PreferenceStoreImpl(PreferenceStorage storage, PreferenceScopeFactory scopeFactory, PreferenceScopeResolutionStrategy defaultScopeResolutionStrategy) {
        this.storage = storage;
        this.scopeFactory = scopeFactory;
        this.defaultScopeResolutionStrategy = defaultScopeResolutionStrategy;
    }

    @Inject
    public PreferenceStoreImpl(PreferenceStorage storage, PreferenceScopeFactory scopeFactory, @Customizable PreferenceScopeResolutionStrategy defaultScopeResolutionStrategy, Instance<PreferenceScopeResolutionStrategy> preferenceScopeResolutionStrategy, InjectionPoint ip) {
        this.storage = storage;
        this.scopeFactory = scopeFactory;
        if (preferenceScopeResolutionStrategy.isUnsatisfied()) {
            if (ip != null) {
                String componentKey = null;
                Annotation annotation = ip.getAnnotated().getAnnotation(ComponentKey.class);
                if (annotation != null) {
                    componentKey = ((ComponentKey)annotation).value();
                }
                this.defaultScopeResolutionStrategy = new DefaultPreferenceScopeResolutionStrategy(scopeFactory, componentKey);
            } else {
                this.defaultScopeResolutionStrategy = defaultScopeResolutionStrategy;
            }
        } else {
            this.defaultScopeResolutionStrategy = (PreferenceScopeResolutionStrategy)preferenceScopeResolutionStrategy.get();
        }
    }

    public PreferenceScopeResolutionStrategyInfo getDefaultScopeResolutionStrategyInfo() {
        return this.defaultScopeResolutionStrategy.getInfo();
    }

    public PreferenceScopeResolver getDefaultScopeResolver() {
        return this.defaultScopeResolutionStrategy.getScopeResolver();
    }

    public <T> void put(PreferenceScope scope, String key, T value) {
        this.storage.write(scope, key, value);
    }

    public <T> void put(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key, T value) {
        this.put(scopeResolutionStrategyInfo.defaultScope(), key, value);
    }

    public <T> void put(String key, T value) {
        this.put(this.defaultScopeResolutionStrategy.getInfo(), key, value);
    }

    public <T> void put(PreferenceScope scope, Map<String, T> valueByKey) {
        valueByKey.forEach((key, value) -> this.put(scope, (String)key, (Object)value));
    }

    public <T> void put(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, Map<String, T> valueByKey) {
        this.put(scopeResolutionStrategyInfo.defaultScope(), valueByKey);
    }

    public <T> void put(Map<String, T> valueByKey) {
        this.put(this.defaultScopeResolutionStrategy.getInfo(), valueByKey);
    }

    public <T> void putIfAbsent(PreferenceScope scope, String key, T value) {
        if (!this.storage.exists(scope, key)) {
            this.put(scope, key, value);
        }
    }

    public <T> void putIfAbsent(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key, T value) {
        this.putIfAbsent(scopeResolutionStrategyInfo.defaultScope(), key, value);
    }

    public <T> void putIfAbsent(String key, T value) {
        this.putIfAbsent(this.defaultScopeResolutionStrategy.getInfo(), key, value);
    }

    public <T> void putIfAbsent(PreferenceScope scope, Map<String, T> valueByKey) {
        valueByKey.forEach((key, value) -> this.putIfAbsent(scope, (String)key, (Object)value));
    }

    public <T> void putIfAbsent(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, Map<String, T> valueByKey) {
        this.putIfAbsent(scopeResolutionStrategyInfo.defaultScope(), valueByKey);
    }

    public <T> void putIfAbsent(Map<String, T> valueByKey) {
        this.putIfAbsent(this.defaultScopeResolutionStrategy.getInfo(), valueByKey);
    }

    public <T> T get(PreferenceScope scope, String key) {
        return (T)this.storage.read(scope, key);
    }

    public <T> T get(PreferenceScope scope, String key, T defaultValue) {
        T value = this.get(scope, key);
        return value != null ? value : defaultValue;
    }

    public <T> T get(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key) {
        return (T)this.storage.read(scopeResolutionStrategyInfo, key);
    }

    public <T> T get(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key, T defaultValue) {
        T value = this.get(scopeResolutionStrategyInfo, key);
        return value != null ? value : defaultValue;
    }

    public <T> T get(String key) {
        return this.get(this.defaultScopeResolutionStrategy.getInfo(), key);
    }

    public <T> T get(String key, T defaultValue) {
        return this.get(this.defaultScopeResolutionStrategy.getInfo(), key, defaultValue);
    }

    public <T> PreferenceScopedValue<T> getScoped(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key) {
        return this.storage.readWithScope(scopeResolutionStrategyInfo, key);
    }

    public <T> PreferenceScopedValue<T> getScoped(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, String key, T defaultValue) {
        PreferenceScopedValue value = this.getScoped(scopeResolutionStrategyInfo, key);
        return value != null ? value : new PreferenceScopedValue(defaultValue, null);
    }

    public <T> PreferenceScopedValue<T> getScoped(String key) {
        return this.getScoped(this.defaultScopeResolutionStrategy.getInfo(), key);
    }

    public <T> PreferenceScopedValue<T> getScoped(String key, T defaultValue) {
        return this.getScoped(this.defaultScopeResolutionStrategy.getInfo(), key, defaultValue);
    }

    public Map<String, Object> search(PreferenceScope scope, Collection<String> keys) {
        if (keys == null) {
            return this.all(scope);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        keys.forEach(key -> map.put((String)key, this.storage.read(scope, key)));
        return map;
    }

    public Map<String, Object> search(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, Collection<String> keys) {
        if (keys == null) {
            return this.all(scopeResolutionStrategyInfo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        keys.forEach(key -> map.put((String)key, this.storage.read(scopeResolutionStrategyInfo, key)));
        return map;
    }

    public Map<String, Object> search(Collection<String> keys) {
        return this.search(this.defaultScopeResolutionStrategy.getInfo(), keys);
    }

    public Map<String, PreferenceScopedValue<Object>> searchScoped(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, Collection<String> keys) {
        if (keys == null) {
            return this.allScoped(scopeResolutionStrategyInfo);
        }
        HashMap<String, PreferenceScopedValue<Object>> map = new HashMap<String, PreferenceScopedValue<Object>>();
        keys.forEach(key -> map.put((String)key, (PreferenceScopedValue<Object>)this.storage.readWithScope(scopeResolutionStrategyInfo, key)));
        return map;
    }

    public Map<String, PreferenceScopedValue<Object>> searchScoped(Collection<String> keys) {
        return this.searchScoped(this.defaultScopeResolutionStrategy.getInfo(), keys);
    }

    public Map<String, Object> all(PreferenceScope scope) {
        return this.search(scope, (Collection<String>)this.storage.allKeys(scope));
    }

    public Map<String, Object> all(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        return this.search(this.storage.allKeys(scopeResolutionStrategyInfo.order()));
    }

    public Map<String, Object> all() {
        return this.all(this.defaultScopeResolutionStrategy.getInfo());
    }

    public Map<String, PreferenceScopedValue<Object>> allScoped(PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        return this.searchScoped(scopeResolutionStrategyInfo, this.storage.allKeys(scopeResolutionStrategyInfo.order()));
    }

    public Map<String, PreferenceScopedValue<Object>> allScoped() {
        return this.allScoped(this.defaultScopeResolutionStrategy.getInfo());
    }

    public void remove(PreferenceScope scope, String key) {
        this.storage.delete(scope, key);
    }

    public void remove(List<PreferenceScope> scopes, String key) {
        scopes.forEach(scope -> this.remove((PreferenceScope)scope, key));
    }
}

