/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class MeetsPredicate
extends AbstractTemporalPredicate<MeetsPredicate> {
    private final long finalRange;

    public MeetsPredicate() {
        this(0L);
    }

    public MeetsPredicate(long finalRange, TimeUnit finalRangeTimeUnit) {
        this(TimeUtil.unitToLong(finalRange, finalRangeTimeUnit));
    }

    private MeetsPredicate(long finalRange) {
        this.finalRange = finalRange;
    }

    public String toString() {
        return (this.negated ? "not " : "") + "meets[" + this.finalRange + "]";
    }

    @Override
    public Interval getInterval() {
        return this.negated ? new Interval(Long.MIN_VALUE, Long.MAX_VALUE) : new Interval(0L, Long.MAX_VALUE);
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long dist = Math.abs(start2 - end1);
        return this.negated ^ dist <= this.finalRange;
    }

    @Override
    protected boolean isTemporalPredicateEqualTo(MeetsPredicate other) {
        return this.finalRange == other.finalRange;
    }
}

