/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import java.util.concurrent.TimeUnit;
import org.drools.model.WindowDefinition;
import org.drools.model.functions.temporal.TimeUtil;
import org.drools.model.impl.ModelComponent;

public abstract class AbstractWindow
implements WindowDefinition,
ModelComponent {
    private final WindowDefinition.Type type;
    private final long value;

    public AbstractWindow(WindowDefinition.Type type, long value) {
        this(type, value, null);
    }

    public AbstractWindow(WindowDefinition.Type type, long value, TimeUnit timeUnit) {
        this.type = type;
        this.value = TimeUtil.unitToLong(value, timeUnit);
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public WindowDefinition.Type getType() {
        return this.type;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractWindow)) {
            return false;
        }
        AbstractWindow that = (AbstractWindow)o;
        return this.type == that.type && this.value == that.value;
    }
}

