/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.ParallelPoolCloserTask;
import com.unboundid.util.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParallelPoolCloser {
    private final boolean unbind;
    private final Collection<LDAPConnection> connections;
    private final int numThreads;

    ParallelPoolCloser(Collection<LDAPConnection> connections, boolean unbind, int numThreads) {
        this.connections = connections;
        this.unbind = unbind;
        this.numThreads = numThreads;
    }

    void closeConnections() {
        int numConnections = this.connections.size();
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(numConnections);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.numThreads, this.numThreads, 0L, TimeUnit.MILLISECONDS, queue);
        ArrayList results = new ArrayList(numConnections);
        for (LDAPConnection lDAPConnection : this.connections) {
            results.add(executor.submit(new ParallelPoolCloserTask(lDAPConnection, this.unbind)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        executor.shutdown();
    }
}

