/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.linemerge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.linemerge.LineMergeDirectedEdge;
import com.vividsolutions.jts.operation.linemerge.LineMergeEdge;
import java.util.ArrayList;
import java.util.List;

public class EdgeString {
    private GeometryFactory factory;
    private List directedEdges = new ArrayList();
    private Coordinate[] coordinates = null;

    public EdgeString(GeometryFactory factory) {
        this.factory = factory;
    }

    public void add(LineMergeDirectedEdge directedEdge) {
        this.directedEdges.add(directedEdge);
    }

    private Coordinate[] getCoordinates() {
        if (this.coordinates == null) {
            int forwardDirectedEdges = 0;
            int reverseDirectedEdges = 0;
            CoordinateList coordinateList = new CoordinateList();
            for (LineMergeDirectedEdge directedEdge : this.directedEdges) {
                if (directedEdge.getEdgeDirection()) {
                    ++forwardDirectedEdges;
                } else {
                    ++reverseDirectedEdges;
                }
                coordinateList.add(((LineMergeEdge)directedEdge.getEdge()).getLine().getCoordinates(), false, directedEdge.getEdgeDirection());
            }
            this.coordinates = coordinateList.toCoordinateArray();
            if (reverseDirectedEdges > forwardDirectedEdges) {
                CoordinateArrays.reverse(this.coordinates);
            }
        }
        return this.coordinates;
    }

    public LineString toLineString() {
        return this.factory.createLineString(this.getCoordinates());
    }
}

