/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.registry.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.ExperimentalFeaturesRegistry;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;

@Portable
public class ExperimentalFeaturesRegistryImpl
implements ExperimentalFeaturesRegistry {
    private List<ExperimentalFeatureImpl> features;

    public ExperimentalFeaturesRegistryImpl(@MapsTo(value="features") List<ExperimentalFeatureImpl> features) {
        this.features = features;
    }

    @Override
    public Optional<ExperimentalFeature> getFeature(String featureId) {
        return this.features.stream().filter(feature -> feature.getFeatureId().equals(featureId)).map(feature -> feature).findAny();
    }

    @Override
    public boolean isFeatureEnabled(String featureId) {
        Optional<ExperimentalFeature> optional = this.getFeature(featureId);
        if (optional.isPresent()) {
            return optional.get().isEnabled();
        }
        return true;
    }

    @Override
    public Collection<ExperimentalFeature> getAllFeatures() {
        return Collections.unmodifiableList(this.features);
    }
}

