/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml.di;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.xml.di.BPMNEdgeHandler;
import org.jbpm.bpmn2.xml.di.BPMNShapeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BPMNPlaneHandler
extends BaseAbstractHandler
implements Handler {
    public BPMNPlaneHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(Definitions.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Process.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String processRef = attrs.getValue("bpmnElement");
        ProcessInfo info = new ProcessInfo(processRef);
        return info;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        ProcessInfo processInfo = (ProcessInfo)parser.getCurrent();
        List processes = ((ProcessBuildData)parser.getData()).getProcesses();
        RuleFlowProcess process = null;
        for (Process p : processes) {
            if (p.getId() == null || !p.getId().equals(processInfo.getProcessRef())) continue;
            process = (RuleFlowProcess)p;
            break;
        }
        if (process != null) {
            for (BPMNShapeHandler.NodeInfo nodeInfo : processInfo.getNodeInfos()) {
                this.processNodeInfo(nodeInfo, process.getNodes());
            }
            this.postProcessNodeOffset(process.getNodes(), 0, 0);
            for (BPMNEdgeHandler.ConnectionInfo connectionInfo : processInfo.getConnectionInfos()) {
                if (connectionInfo.getBendpoints() == null) continue;
                this.processConnectionInfo(connectionInfo, process.getNodes());
            }
        }
        return processInfo;
    }

    private boolean processNodeInfo(BPMNShapeHandler.NodeInfo nodeInfo, Node[] nodes) {
        if (nodeInfo == null || nodeInfo.getNodeRef() == null) {
            return false;
        }
        for (Node node : nodes) {
            boolean found;
            String id = (String)node.getMetaData().get("UniqueId");
            if (nodeInfo.getNodeRef().equals(id)) {
                ((org.jbpm.workflow.core.Node)node).setMetaData("x", (Object)nodeInfo.getX());
                ((org.jbpm.workflow.core.Node)node).setMetaData("y", (Object)nodeInfo.getY());
                ((org.jbpm.workflow.core.Node)node).setMetaData("width", (Object)nodeInfo.getWidth());
                ((org.jbpm.workflow.core.Node)node).setMetaData("height", (Object)nodeInfo.getHeight());
                return true;
            }
            if (!(node instanceof NodeContainer) || !(found = this.processNodeInfo(nodeInfo, ((NodeContainer)node).getNodes()))) continue;
            return true;
        }
        return false;
    }

    private void postProcessNodeOffset(Node[] nodes, int xOffset, int yOffset) {
        for (Node node : nodes) {
            Integer y;
            Integer x = (Integer)node.getMetaData().get("x");
            if (x != null) {
                ((org.jbpm.workflow.core.Node)node).setMetaData("x", (Object)(x - xOffset));
            }
            if ((y = (Integer)node.getMetaData().get("y")) != null) {
                ((org.jbpm.workflow.core.Node)node).setMetaData("y", (Object)(y - yOffset));
            }
            if (!(node instanceof NodeContainer)) continue;
            this.postProcessNodeOffset(((NodeContainer)node).getNodes(), xOffset + (x == null ? 0 : x), yOffset + (y == null ? 0 : y));
        }
    }

    private boolean processConnectionInfo(BPMNEdgeHandler.ConnectionInfo connectionInfo, Node[] nodes) {
        for (Node node : nodes) {
            boolean found;
            for (List connections : node.getOutgoingConnections().values()) {
                for (Connection connection : connections) {
                    String id = (String)connection.getMetaData().get("UniqueId");
                    if (id == null || !id.equals(connectionInfo.getElementRef())) continue;
                    ((ConnectionImpl)connection).setMetaData("bendpoints", (Object)connectionInfo.getBendpoints());
                    return true;
                }
            }
            if (!(node instanceof NodeContainer) || !(found = this.processConnectionInfo(connectionInfo, ((NodeContainer)node).getNodes()))) continue;
            return true;
        }
        return false;
    }

    public Class<?> generateNodeFor() {
        return ProcessInfo.class;
    }

    public static class ProcessInfo {
        private String processRef;
        private List<BPMNShapeHandler.NodeInfo> nodeInfos = new ArrayList<BPMNShapeHandler.NodeInfo>();
        private List<BPMNEdgeHandler.ConnectionInfo> connectionInfos = new ArrayList<BPMNEdgeHandler.ConnectionInfo>();

        public ProcessInfo(String processRef) {
            this.processRef = processRef;
        }

        public String getProcessRef() {
            return this.processRef;
        }

        public void addNodeInfo(BPMNShapeHandler.NodeInfo nodeInfo) {
            this.nodeInfos.add(nodeInfo);
        }

        public List<BPMNShapeHandler.NodeInfo> getNodeInfos() {
            return this.nodeInfos;
        }

        public void addConnectionInfo(BPMNEdgeHandler.ConnectionInfo connectionInfo) {
            this.connectionInfos.add(connectionInfo);
        }

        public List<BPMNEdgeHandler.ConnectionInfo> getConnectionInfos() {
            return this.connectionInfos;
        }
    }
}

