/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import java.io.Serializable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;

@Portable
public class GAV
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;

    public GAV() {
        this(null, null, null);
    }

    public GAV(String gavString) {
        String[] split = ((String)PortablePreconditions.checkNotNull((String)"gavString", (Object)gavString)).split(":");
        if (split.length < 3) {
            throw new IllegalArgumentException("The GAV String must have the form group:artifact:version[:scope] but was '" + gavString + "'");
        }
        this.groupId = split[0];
        this.artifactId = split[1];
        this.version = split[2];
    }

    public GAV(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public boolean isGAVEqual(Object o) {
        return this.equals(o);
    }

    public boolean isSnapshot() {
        return this.version != null && this.version.endsWith("-SNAPSHOT");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GAV)) {
            return false;
        }
        GAV gav = (GAV)o;
        if (this.artifactId != null ? !this.artifactId.equals(gav.artifactId) : gav.artifactId != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(gav.groupId) : gav.groupId != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(gav.version) : gav.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

