/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.xni.QName;

public class SimpleContentModel
implements ContentModelValidator {
    public static final short CHOICE = -1;
    public static final short SEQUENCE = -1;
    private final QName fFirstChild = new QName();
    private final QName fSecondChild = new QName();
    private final int fOperator;

    public SimpleContentModel(short operator, QName firstChild, QName secondChild) {
        this.fFirstChild.setValues(firstChild);
        if (secondChild != null) {
            this.fSecondChild.setValues(secondChild);
        } else {
            this.fSecondChild.clear();
        }
        this.fOperator = operator;
    }

    public int validate(QName[] children, int offset, int length) {
        switch (this.fOperator) {
            case 0: {
                if (length == 0) {
                    return 0;
                }
                if (children[offset].rawname != this.fFirstChild.rawname) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 1: {
                if (length == 1 && children[offset].rawname != this.fFirstChild.rawname) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 2: {
                if (length <= 0) break;
                for (int index = 0; index < length; ++index) {
                    if (children[offset + index].rawname == this.fFirstChild.rawname) continue;
                    return index;
                }
                break;
            }
            case 3: {
                if (length == 0) {
                    return 0;
                }
                for (int index = 0; index < length; ++index) {
                    if (children[offset + index].rawname == this.fFirstChild.rawname) continue;
                    return index;
                }
                break;
            }
            case 4: {
                if (length == 0) {
                    return 0;
                }
                if (children[offset].rawname != this.fFirstChild.rawname && children[offset].rawname != this.fSecondChild.rawname) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 5: {
                if (length == 2) {
                    if (children[offset].rawname != this.fFirstChild.rawname) {
                        return 0;
                    }
                    if (children[offset + 1].rawname == this.fSecondChild.rawname) break;
                    return 1;
                }
                if (length > 2) {
                    return 2;
                }
                return length;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return -1;
    }
}

