/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.log.Logger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.uberfire.annotations.processors.EclipseWorkaroundProcessingEnvironment;
import org.uberfire.annotations.processors.GeneratorUtils;

public abstract class AbstractErrorAbsorbingProcessor
extends AbstractProcessor {
    private Throwable rememberedInitError;

    protected AbstractErrorAbsorbingProcessor() {
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            this.rememberedInitError = e;
        }
    }

    private static AnnotationMirror findAnnotationMirror(Element target, TypeElement annotationType) {
        Name annotationTypeName = annotationType.getQualifiedName();
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            if (!GeneratorUtils.getQualifiedName(annotationMirror).contentEquals(annotationTypeName)) continue;
            return annotationMirror;
        }
        return null;
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(new EclipseWorkaroundProcessingEnvironment(env));
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (this.rememberedInitError != null) {
                throw this.rememberedInitError;
            }
            return this.processWithExceptions(annotations, roundEnv);
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            String errorMessage = "Internal error in " + this.getClass().getName() + stringWriter.toString();
            boolean emittedSpecificError = false;
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage, element, AbstractErrorAbsorbingProcessor.findAnnotationMirror(element, typeElement));
                    emittedSpecificError = true;
                }
            }
            if (!emittedSpecificError) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage);
            }
            return false;
        }
    }

    protected void rememberInitializationError(Throwable t) {
        this.rememberedInitError = t;
    }

    protected abstract boolean processWithExceptions(Set<? extends TypeElement> var1, RoundEnvironment var2) throws Exception;

    protected final void writeCode(String packageName, String className, StringBuffer code) throws IOException {
        JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(packageName + "." + className, new Element[0]);
        try (Writer w = jfo.openWriter();
             BufferedWriter bw = new BufferedWriter(w);){
            bw.append(code);
        }
    }
}

