/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.service.impact;

import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePartReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.refactoring.service.impact.AbstractOperationRequest;
import org.kie.workbench.common.services.refactoring.service.impact.DeleteOperationRequest;
import org.kie.workbench.common.services.refactoring.service.impact.OperationType;
import org.kie.workbench.common.services.refactoring.service.impact.QueryOperationRequest;
import org.kie.workbench.common.services.refactoring.service.impact.RefactorOperationBuilder;
import org.kie.workbench.common.services.refactoring.service.impact.RefactorOperationRequest;

public class RefactorOperationBuilderFactory {
    private static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newInstance(OperationType operation) {
        AbstractOperationRequest request;
        switch (operation) {
            case QUERY: {
                request = new QueryOperationRequest();
                break;
            }
            case DELETE: {
                request = new DeleteOperationRequest();
                break;
            }
            case REFACTOR: {
                request = new RefactorOperationRequest();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported request type: " + operation.toString());
            }
        }
        return new RefactorOperationBuilder<QueryOperationRequest>(operation, (QueryOperationRequest)request);
    }

    public static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newResourceBasedInstance(String resourceName, ResourceType type, OperationType operation) {
        RefactorOperationBuilder<T> builder = RefactorOperationBuilderFactory.newInstance(operation);
        builder.getQueryTerms().add(new ValueReferenceIndexTerm(resourceName, type));
        return builder;
    }

    public static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newResourceBasedInstance(String resourceName, ResourceType type, String newResourceName, OperationType operation) {
        RefactorOperationBuilder<T> builder = RefactorOperationBuilderFactory.newInstance(operation);
        return builder;
    }

    public static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newResourceBasedInstance(String resourceName, ResourceType type, ValueIndexTerm.TermSearchType searchType, OperationType operation) {
        RefactorOperationBuilder<T> builder = RefactorOperationBuilderFactory.newInstance(operation);
        builder.getQueryTerms().add(new ValueReferenceIndexTerm(resourceName, type, searchType));
        return builder;
    }

    public static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newSharedPartBasedInstance(String sharedPartName, PartType type, OperationType operation) {
        RefactorOperationBuilder<T> builder = RefactorOperationBuilderFactory.newInstance(operation);
        builder.getQueryTerms().add(new ValueSharedPartIndexTerm(sharedPartName, type));
        return builder;
    }

    public static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newSharedPartBasedInstance(String sharedPartName, PartType type, ValueIndexTerm.TermSearchType searchType, OperationType operation) {
        RefactorOperationBuilder<T> builder = RefactorOperationBuilderFactory.newInstance(operation);
        builder.getQueryTerms().add(new ValueSharedPartIndexTerm(sharedPartName, type, searchType));
        return builder;
    }

    public static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newResourcePartBasedInstance(String resourceName, String partName, PartType partType, OperationType operation) {
        RefactorOperationBuilder<T> builder = RefactorOperationBuilderFactory.newInstance(operation);
        builder.getQueryTerms().add(new ValuePartReferenceIndexTerm(resourceName, partName, partType));
        return builder;
    }

    public static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newResourcePartBasedInstance(String resourceName, String partName, PartType partType, ValueIndexTerm.TermSearchType searchType, OperationType operation) {
        RefactorOperationBuilder<T> builder = RefactorOperationBuilderFactory.newInstance(operation);
        builder.getQueryTerms().add(new ValuePartReferenceIndexTerm(resourceName, partName, partType, searchType));
        return builder;
    }

    public static <T extends AbstractOperationRequest> RefactorOperationBuilder<T> newResourcePartBasedInstance(String resourceName, String partName, PartType partType, String newPartName, OperationType operation) {
        RefactorOperationBuilder<T> builder = RefactorOperationBuilderFactory.newInstance(operation);
        return builder;
    }
}

