/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.instance.JobRequestInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.api.model.instance.RequestInfoInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.JobServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class JobServicesClientImpl
extends AbstractKieServicesClientImpl
implements JobServicesClient {
    public JobServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public JobServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public Long scheduleRequest(JobRequestInstance jobRequest) {
        return this.scheduleRequest("", jobRequest);
    }

    @Override
    public Long scheduleRequest(String containerId, JobRequestInstance jobRequest) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = "";
            if (containerId != null && !containerId.isEmpty()) {
                queryString = "?containerId=" + containerId;
            }
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs", valuesMap) + queryString, jobRequest, Object.class);
        } else {
            if (containerId == null) {
                containerId = "";
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "scheduleRequest", this.serialize(jobRequest), this.marshaller.getFormat().getType(), new Object[]{containerId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public void cancelRequest(long requestId) {
        this.cancelRequest(null, requestId);
    }

    @Override
    public void cancelRequest(String containerId, long requestId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("jobId", requestId);
            String queryString = "";
            if (containerId != null && !containerId.isEmpty()) {
                queryString = "?containerId=" + containerId;
            }
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/{jobId}", valuesMap) + queryString, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "cancelRequest", new Object[]{requestId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void updateRequestData(long requestId, String containerId, Map<String, Object> data) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("jobId", requestId);
            String queryString = "";
            if (containerId != null && !containerId.isEmpty()) {
                queryString = "?containerId=" + containerId;
            }
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/{jobId}/data", valuesMap) + queryString, data, Object.class);
        } else {
            if (containerId == null) {
                containerId = "";
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "updateRequestData", this.serialize(this.safeMap(data)), this.marshaller.getFormat().getType(), new Object[]{requestId, containerId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void requeueRequest(long requestId) {
        this.requeueRequest(null, requestId);
    }

    @Override
    public void requeueRequest(String containerId, long requestId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("jobId", requestId);
            String queryString = "";
            if (containerId != null && !containerId.isEmpty()) {
                queryString = "?containerId=" + containerId;
            }
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/{jobId}", valuesMap) + queryString, "", String.class, new HashMap<String, String>());
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "requeueRequest", new Object[]{requestId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public List<RequestInfoInstance> getRequestsByStatus(List<String> statuses, Integer page, Integer pageSize) {
        RequestInfoInstanceList list = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQuery = this.getAdditionalParams("", "status", statuses);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs", valuesMap) + queryString, RequestInfoInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "getRequestsByStatus", new Object[]{this.safeList(statuses), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (RequestInfoInstanceList)response.getResult();
        }
        if (list != null && list.getRequestInfoInstances() != null) {
            return Arrays.asList(list.getRequestInfoInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequestInfoInstance> getRequestsByBusinessKey(String businessKey, Integer page, Integer pageSize) {
        RequestInfoInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("key", businessKey);
            String queryString = this.getPagingQueryString("", page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/keys/{key}", valuesMap) + queryString, RequestInfoInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "getRequestsByBusinessKey", new Object[]{businessKey, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (RequestInfoInstanceList)response.getResult();
        }
        if (list != null && list.getRequestInfoInstances() != null) {
            return Arrays.asList(list.getRequestInfoInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequestInfoInstance> getRequestsByBusinessKey(String businessKey, List<String> statuses, Integer page, Integer pageSize) {
        RequestInfoInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("key", businessKey);
            String statusQuery = this.getAdditionalParams("", "status", statuses);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/keys/{key}", valuesMap) + queryString, RequestInfoInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "getRequestsByBusinessKey", new Object[]{businessKey, this.safeList(statuses), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (RequestInfoInstanceList)response.getResult();
        }
        if (list != null && list.getRequestInfoInstances() != null) {
            return Arrays.asList(list.getRequestInfoInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequestInfoInstance> getRequestsByCommand(String command, Integer page, Integer pageSize) {
        RequestInfoInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("cmd", command);
            String queryString = this.getPagingQueryString("", page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/commands/{cmd}", valuesMap) + queryString, RequestInfoInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "getRequestsByCommand", new Object[]{command, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (RequestInfoInstanceList)response.getResult();
        }
        if (list != null && list.getRequestInfoInstances() != null) {
            return Arrays.asList(list.getRequestInfoInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequestInfoInstance> getRequestsByCommand(String command, List<String> statuses, Integer page, Integer pageSize) {
        RequestInfoInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("cmd", command);
            String statusQuery = this.getAdditionalParams("", "status", statuses);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/commands/{cmd}", valuesMap) + queryString, RequestInfoInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "getRequestsByCommand", new Object[]{command, this.safeList(statuses), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (RequestInfoInstanceList)response.getResult();
        }
        if (list != null && list.getRequestInfoInstances() != null) {
            return Arrays.asList(list.getRequestInfoInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequestInfoInstance> getRequestsByContainer(String containerId, List<String> statuses, Integer page, Integer pageSize) {
        RequestInfoInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            String statusQuery = this.getAdditionalParams("", "status", statuses);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/containers/{containerId}", valuesMap) + queryString, RequestInfoInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "getRequestsByContainer", new Object[]{containerId, this.safeList(statuses), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (RequestInfoInstanceList)response.getResult();
        }
        if (list != null && list.getRequestInfoInstances() != null) {
            return Arrays.asList(list.getRequestInfoInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequestInfoInstance> getRequestsByProcessInstance(Long processInstanceId, List<String> statuses, Integer page, Integer pageSize) {
        RequestInfoInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("processInstanceId", processInstanceId);
            String statusQuery = this.getAdditionalParams("", "status", statuses);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/processes/instances/{processInstanceId}", valuesMap) + queryString, RequestInfoInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "getRequestsByProcessInstance", new Object[]{processInstanceId, this.safeList(statuses), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (RequestInfoInstanceList)response.getResult();
        }
        if (list != null && list.getRequestInfoInstances() != null) {
            return Arrays.asList(list.getRequestInfoInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public RequestInfoInstance getRequestById(Long requestId, boolean withErrors, boolean withData) {
        return this.getRequestById(null, requestId, withErrors, withData);
    }

    @Override
    public RequestInfoInstance getRequestById(String containerId, Long requestId, boolean withErrors, boolean withData) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("jobId", requestId);
            String queryString = "";
            if (containerId != null && !containerId.isEmpty()) {
                queryString = "&containerId=" + containerId;
            }
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"jobs/{jobId}", valuesMap) + "?withErrors=" + withErrors + "&withData=" + withData + queryString, RequestInfoInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("JobService", "getRequestById", this.marshaller.getFormat().getType(), new Object[]{requestId, withErrors, withData})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return this.deserialize((String)response.getResult(), RequestInfoInstance.class);
    }
}

