/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_2.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Map;
import javax.xml.namespace.QName;
import org.kie.dmn.backend.marshalling.CustomStaxReader;
import org.kie.dmn.backend.marshalling.CustomStaxWriter;
import org.kie.dmn.backend.marshalling.v1_2.xstream.DMNBaseConverter;
import org.kie.dmn.model.v1_2.KieDMNModelInstrumentedBase;
import org.kie.dmn.model.v1_2.TDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMNModelInstrumentedBaseConverter
extends DMNBaseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DMNModelInstrumentedBaseConverter.class);

    public DMNModelInstrumentedBaseConverter(XStream xstream) {
        super(xstream.getMapper());
    }

    @Override
    protected void assignChildElement(Object parent, String nodeName, Object child) {
    }

    @Override
    protected void assignAttributes(HierarchicalStreamReader reader, Object parent) {
        KieDMNModelInstrumentedBase mib = (KieDMNModelInstrumentedBase)parent;
        CustomStaxReader customStaxReader = (CustomStaxReader)reader.underlyingReader();
        Map<String, String> currentNSCtx = customStaxReader.getNsContext();
        mib.getNsContext().putAll(currentNSCtx);
        mib.setLocation(customStaxReader.getLocation());
        mib.setAdditionalAttributes(customStaxReader.getAdditionalAttributes());
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
    }

    @Override
    protected void writeAttributes(HierarchicalStreamWriter writer, Object parent) {
        KieDMNModelInstrumentedBase mib = (KieDMNModelInstrumentedBase)parent;
        CustomStaxWriter staxWriter = (CustomStaxWriter)writer.underlyingWriter();
        for (Map.Entry kv : mib.getNsContext().entrySet()) {
            try {
                if ("http://www.omg.org/spec/DMN/20180521/MODEL/".equals(kv.getValue())) continue;
                staxWriter.writeNamespace((String)kv.getKey(), (String)kv.getValue());
            }
            catch (Exception e) {
                LOG.warn("The XML driver writer failed to manage writing namespace, namespaces prefixes could be wrong in the resulting file.", (Throwable)e);
            }
        }
        for (Map.Entry kv : mib.getAdditionalAttributes().entrySet()) {
            staxWriter.addAttribute(((QName)kv.getKey()).getPrefix() + ":" + ((QName)kv.getKey()).getLocalPart(), (String)kv.getValue());
        }
        if (parent instanceof TDefinitions) {
            TDefinitions tDefinitions = (TDefinitions)parent;
            String dmndiPrefix = tDefinitions.getPrefixForNamespaceURI("http://www.omg.org/spec/DMN/20180521/DMNDI/").orElse("dmndi");
            String diPrefix = tDefinitions.getPrefixForNamespaceURI("http://www.omg.org/spec/DMN/20180521/DI/").orElse("di");
            String dcPrefix = tDefinitions.getPrefixForNamespaceURI("http://www.omg.org/spec/DMN/20180521/DC/").orElse("dc");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "DMNDI", dmndiPrefix), "DMNDI");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "DMNDiagram", dmndiPrefix), "DMNDiagram");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "DMNStyle", dmndiPrefix), "style");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "DMNStyle", dmndiPrefix), "DMNStyle");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "DMNShape", dmndiPrefix), "DMNShape");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "DMNEdge", dmndiPrefix), "DMNEdge");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "DMNDecisionServiceDividerLine", dmndiPrefix), "DMNDecisionServiceDividerLine");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "DMNLabel", dmndiPrefix), "DMNLabel");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "Text", dmndiPrefix), "Text");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "Size", dmndiPrefix), "Size");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "FillColor", dmndiPrefix), "FillColor");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "StrokeColor", dmndiPrefix), "StrokeColor");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DMNDI/", "FontColor", dmndiPrefix), "FontColor");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DI/", "waypoint", diPrefix), "waypoint");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DI/", "extension", diPrefix), "extension");
            staxWriter.getQNameMap().registerMapping(new QName("http://www.omg.org/spec/DMN/20180521/DC/", "Bounds", dcPrefix), "Bounds");
        }
    }
}

