/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.MapBasedPersistenceContext;
import org.jbpm.persistence.NonTransactionalProcessPersistentSession;
import org.jbpm.persistence.ProcessStorage;
import org.jbpm.persistence.api.PersistentCorrelationKey;
import org.jbpm.persistence.api.PersistentProcessInstance;
import org.jbpm.persistence.api.ProcessPersistenceContext;
import org.kie.internal.process.CorrelationKey;

public class MapBasedProcessPersistenceContext
extends MapBasedPersistenceContext
implements ProcessPersistenceContext,
NonTransactionalProcessPersistentSession {
    private ProcessStorage storage;
    private Map<Long, PersistentProcessInstance> processes;
    private Map<PersistentCorrelationKey, PersistentProcessInstance> processInstancesByBusinessKey;

    public MapBasedProcessPersistenceContext(ProcessStorage storage) {
        super((KnowledgeSessionStorage)storage);
        this.storage = storage;
        this.processes = new HashMap<Long, PersistentProcessInstance>();
        this.processInstancesByBusinessKey = new HashMap<PersistentCorrelationKey, PersistentProcessInstance>();
    }

    public PersistentProcessInstance persist(PersistentProcessInstance processInstanceInfo) {
        if (processInstanceInfo.getId() == null) {
            processInstanceInfo.setId(Long.valueOf(this.storage.getNextProcessInstanceId()));
        }
        this.processes.put(processInstanceInfo.getId(), processInstanceInfo);
        return processInstanceInfo;
    }

    public PersistentProcessInstance findProcessInstanceInfo(Long processId) {
        PersistentProcessInstance processInstanceInfo = this.processes.get(processId);
        if (processInstanceInfo == null) {
            processInstanceInfo = this.storage.findProcessInstanceInfo(processId);
        }
        return processInstanceInfo;
    }

    @Override
    public List<PersistentProcessInstance> getStoredProcessInstances() {
        return Collections.unmodifiableList(new ArrayList<PersistentProcessInstance>(this.processes.values()));
    }

    public void close() {
        super.close();
        this.clearStoredProcessInstances();
    }

    public void remove(PersistentProcessInstance processInstanceInfo) {
        this.storage.removeProcessInstanceInfo(processInstanceInfo.getId());
    }

    public List<Long> getProcessInstancesWaitingForEvent(String type) {
        return this.storage.getProcessInstancesWaitingForEvent(type);
    }

    @Override
    public void clearStoredProcessInstances() {
        this.processes.clear();
    }

    public PersistentCorrelationKey persist(PersistentCorrelationKey correlationKeyInfo) {
        PersistentProcessInstance piInfo = this.processes.get(correlationKeyInfo.getProcessInstanceId());
        if (piInfo != null) {
            this.processInstancesByBusinessKey.put(correlationKeyInfo, piInfo);
        }
        return correlationKeyInfo;
    }

    public Long getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        PersistentProcessInstance piInfo = this.processInstancesByBusinessKey.get(correlationKey);
        return piInfo.getId();
    }
}

