/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.settings;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaSettings {
    private static JpaSettings INSTANCE = new JpaSettings();
    private static final Logger logger = LoggerFactory.getLogger(JpaSettings.class);
    private String dataSourceJndiName = null;

    public static JpaSettings get() {
        return INSTANCE;
    }

    private JpaSettings() {
    }

    public String getDataSourceJndiName() {
        if (this.dataSourceJndiName == null) {
            this.dataSourceJndiName = this.findJndiDataSourceName();
        }
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    private String findJndiDataSourceName() {
        String defaultName = System.getProperty("org.kie.ds.jndi", "java:jboss/datasources/ExampleDS");
        try {
            String jndiName = this.getJndiNameFromPersistenceXml();
            if (jndiName != null) {
                return jndiName;
            }
        }
        catch (XMLStreamException e) {
            logger.warn("Unable to find out JNDI name fo data source due to {} using default {}", new Object[]{e.getMessage(), defaultName, e});
        }
        return defaultName;
    }

    private String getJndiNameFromPersistenceXml() throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/persistence.xml");
        XMLStreamReader reader = factory.createXMLStreamReader(is);
        while (reader.hasNext()) {
            int event = reader.next();
            if (event != 1 || !"jta-data-source".equals(reader.getLocalName())) continue;
            return reader.getElementText();
        }
        return null;
    }
}

