/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.casemgmt;

import java.util.Collections;
import java.util.Map;
import org.jbpm.casemgmt.api.admin.CaseInstanceMigrationService;
import org.jbpm.casemgmt.api.admin.CaseMigrationReport;
import org.kie.server.api.model.cases.CaseMigrationReportInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.ConvertUtils;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseAdminServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(CaseAdminServiceBase.class);
    private CaseInstanceMigrationService caseInstanceMigrationService;
    private MarshallerHelper marshallerHelper;
    private KieServerRegistry context;

    public CaseAdminServiceBase(CaseInstanceMigrationService caseInstanceMigrationService, KieServerRegistry context) {
        this.caseInstanceMigrationService = caseInstanceMigrationService;
        this.marshallerHelper = new MarshallerHelper(context);
        this.context = context;
    }

    public CaseMigrationReportInstance migrateCaseInstance(String containerId, String caseId, String targetContainerId, String payload, String marshallingType) {
        Map mapping = Collections.emptyMap();
        if (payload != null) {
            logger.debug("About to unmarshal mapping from payload: '{}' using container {} marshaller", (Object)payload, (Object)containerId);
            mapping = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        }
        if (mapping == null || !mapping.containsKey("ProcessMapping")) {
            throw new IllegalArgumentException("Case instance migration requires ProcessMapping to be provided");
        }
        Map processMapping = (Map)mapping.get("ProcessMapping");
        Map nodeMapping = mapping.getOrDefault("NodeMapping", Collections.emptyMap());
        logger.debug("About to migrate case instance with id {} from container '{}' to container '{}' with process mapping '{}' and with node mapping {}", new Object[]{caseId, containerId, targetContainerId, processMapping, nodeMapping});
        CaseMigrationReport report = this.caseInstanceMigrationService.migrate(caseId, targetContainerId, processMapping, nodeMapping);
        logger.debug("Migration of case instance {} finished with report {}", (Object)caseId, (Object)report);
        return ConvertUtils.convertCaseMigrationReport(caseId, report);
    }
}

