/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.jbpm.executor.commands.error.AutoAckErrorCommand;
import org.jbpm.runtime.manager.impl.jpa.ExecutionErrorInfo;
import org.kie.api.executor.STATUS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobAutoAckErrorCommand
extends AutoAckErrorCommand {
    private static final Logger logger = LoggerFactory.getLogger(JobAutoAckErrorCommand.class);
    private static final String RULE = "Jobs that previously failed but now are in one of the statuses - queued, completed or cancelled";

    @Override
    protected List<ExecutionErrorInfo> findErrorsToAck(EntityManager em) {
        List<Object> errorsToAck = new ArrayList<ExecutionErrorInfo>();
        TransactionManager txm = TransactionManagerFactory.get().newTransactionManager();
        boolean txOwner = txm.begin();
        try {
            String findJobErrorsQuery = "select error from ExecutionErrorInfo error where error.type = :type and error.acknowledged =:acknowledged and error.jobId in (select req.id from RequestInfo req where status in (:status))";
            errorsToAck = em.createQuery(findJobErrorsQuery, ExecutionErrorInfo.class).setParameter("type", (Object)"Job").setParameter("acknowledged", (Object)new Short("0")).setParameter("status", Arrays.asList(STATUS.DONE, STATUS.CANCELLED, STATUS.QUEUED)).getResultList();
            txm.commit(txOwner);
        }
        catch (Exception e) {
            logger.error("Execution error in command ProcessAutoAckErrorCommand", (Throwable)e);
            txm.rollback(txOwner);
        }
        return errorsToAck;
    }

    @Override
    protected String getAckRule() {
        return RULE;
    }
}

