/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.entities.RequestInfo;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.instance.ErrorInfoInstance;
import org.kie.server.api.model.instance.ErrorInfoInstanceList;
import org.kie.server.api.model.instance.JobRequestInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.api.model.instance.RequestInfoInstanceList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceBase {
    public static final Logger logger = LoggerFactory.getLogger(ExecutorServiceBase.class);
    private ExecutorService executorService;
    private MarshallerHelper marshallerHelper;
    private KieServerRegistry context;

    public ExecutorServiceBase(ExecutorService executorService, KieServerRegistry context) {
        this.executorService = executorService;
        this.marshallerHelper = new MarshallerHelper(context);
        this.context = context;
    }

    public String scheduleRequest(String containerId, String payload, String marshallingType) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        JobRequestInstance jobRequest = null;
        if (containerId != null && !containerId.isEmpty()) {
            logger.debug("About to unmarshal job request from payload: '{}' using container {} marshaller", (Object)payload, (Object)containerId);
            jobRequest = (JobRequestInstance)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, JobRequestInstance.class);
            jobRequest.getData().put("deploymentId", containerId);
            classLoader = this.context.getContainer(containerId).getKieContainer().getClassLoader();
        } else {
            logger.debug("About to unmarshal job request from payload: '{}' using server marshaller", (Object)payload);
            jobRequest = (JobRequestInstance)this.marshallerHelper.unmarshal(payload, marshallingType, JobRequestInstance.class);
        }
        Long requestId = null;
        if (!this.validateCommand(jobRequest.getCommand(), classLoader)) {
            throw new IllegalArgumentException("Invalid command type " + jobRequest.getCommand());
        }
        if (jobRequest.getScheduledDate() != null) {
            logger.debug("Scheduling job at future date '{}' for request {}", (Object)jobRequest.getScheduledDate(), (Object)jobRequest);
            requestId = this.executorService.scheduleRequest(jobRequest.getCommand(), jobRequest.getScheduledDate(), new CommandContext(jobRequest.getData()));
        } else {
            logger.debug("Scheduling job at current date '{}' for request {}", (Object)new Date(), (Object)jobRequest);
            requestId = this.executorService.scheduleRequest(jobRequest.getCommand(), new CommandContext(jobRequest.getData()));
        }
        String response = this.marshallerHelper.marshal(marshallingType, (Object)requestId);
        return response;
    }

    public void cancelRequest(long requestId) {
        logger.debug("About to cancel job with id {}", (Object)requestId);
        this.executorService.cancelRequest(Long.valueOf(requestId));
    }

    public void requeueRequest(long requestId) {
        logger.debug("About to requeue job with id {}", (Object)requestId);
        ((RequeueAware)this.executorService).requeueById(Long.valueOf(requestId));
    }

    public void updateRequestData(long requestId, String containerId, String payload, String marshallingType) {
        Map data = null;
        if (containerId != null && !containerId.isEmpty()) {
            logger.debug("About to unmarshal job data from payload: '{}' using container {} marshaller", (Object)payload, (Object)containerId);
            data = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        } else {
            logger.debug("About to unmarshal job data from payload: '{}' using server marshaller", (Object)payload);
            data = (Map)this.marshallerHelper.unmarshal(payload, marshallingType, Map.class);
        }
        logger.debug("About to update job's ( with id {}) data {}", (Object)requestId, (Object)data);
        this.executorService.updateRequestData(Long.valueOf(requestId), data);
    }

    public RequestInfoInstanceList getRequestsByStatus(List<String> statuses, Integer page, Integer pageSize) {
        List<STATUS> statusList = this.convertStatusList(statuses);
        List requests = this.executorService.getRequestsByStatus(statusList, this.buildQueryContext(page, pageSize));
        RequestInfoInstanceList result = this.convertToRequestInfoList(requests, false, false);
        return result;
    }

    public RequestInfoInstanceList getRequestsByBusinessKey(String businessKey, Integer page, Integer pageSize) {
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, this.buildQueryContext(page, pageSize));
        RequestInfoInstanceList result = this.convertToRequestInfoList(requests, false, false);
        return result;
    }

    public RequestInfoInstanceList getRequestsByBusinessKey(String businessKey, List<String> statuses, Integer page, Integer pageSize) {
        List<STATUS> statusList = this.convertStatusList(statuses);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, statusList, this.buildQueryContext(page, pageSize));
        RequestInfoInstanceList result = this.convertToRequestInfoList(requests, false, false);
        return result;
    }

    public RequestInfoInstanceList getRequestsByCommand(String command, Integer page, Integer pageSize) {
        List requests = this.executorService.getRequestsByCommand(command, this.buildQueryContext(page, pageSize));
        RequestInfoInstanceList result = this.convertToRequestInfoList(requests, false, false);
        return result;
    }

    public RequestInfoInstanceList getRequestsByCommand(String command, List<String> statuses, Integer page, Integer pageSize) {
        List<STATUS> statusList = this.convertStatusList(statuses);
        List requests = this.executorService.getRequestsByCommand(command, statusList, this.buildQueryContext(page, pageSize));
        RequestInfoInstanceList result = this.convertToRequestInfoList(requests, false, false);
        return result;
    }

    public RequestInfoInstanceList getRequestsByContainer(String containerId, List<String> statuses, Integer page, Integer pageSize) {
        List<STATUS> statusList = this.convertStatusList(statuses);
        List requests = this.executorService.getRequestsByDeployment(containerId, statusList, this.buildQueryContext(page, pageSize));
        RequestInfoInstanceList result = this.convertToRequestInfoList(requests, false, false);
        return result;
    }

    public RequestInfoInstanceList getRequestsByProcessInstance(Number processInstanceId, List<String> statuses, Integer page, Integer pageSize) {
        List<STATUS> statusList = this.convertStatusList(statuses);
        List requests = this.executorService.getRequestsByProcessInstance(Long.valueOf(processInstanceId.longValue()), statusList, this.buildQueryContext(page, pageSize));
        RequestInfoInstanceList result = this.convertToRequestInfoList(requests, false, false);
        return result;
    }

    public String getRequestById(long requestId, boolean withErrors, boolean withData, String marshallingType) {
        String result = null;
        org.kie.api.executor.RequestInfo request = this.executorService.getRequestById(Long.valueOf(requestId));
        if (request == null) {
            throw new IllegalArgumentException("Request with id: " + requestId + " doesn't exist");
        }
        RequestInfoInstance requestInstance = this.convertToRequestInfo(request, withErrors, withData);
        String deploymentId = ((RequestInfo)request).getDeploymentId();
        result = deploymentId != null && this.context.getContainer(deploymentId) != null ? this.marshallerHelper.marshal(deploymentId, marshallingType, (Object)requestInstance) : this.marshallerHelper.marshal(marshallingType, (Object)requestInstance);
        return result;
    }

    protected RequestInfoInstanceList convertToRequestInfoList(List<org.kie.api.executor.RequestInfo> requests, boolean withErrors, boolean withData) {
        RequestInfoInstance[] requestInfos = new RequestInfoInstance[requests.size()];
        int index = 0;
        for (org.kie.api.executor.RequestInfo request : requests) {
            requestInfos[index] = this.convertToRequestInfo(request, withErrors, withData);
            ++index;
        }
        return new RequestInfoInstanceList(requestInfos);
    }

    protected RequestInfoInstance convertToRequestInfo(org.kie.api.executor.RequestInfo request, boolean withErrors, boolean withData) {
        RequestInfoInstance.Builder builder = RequestInfoInstance.builder().id(request.getId()).businessKey(request.getKey()).command(request.getCommandName()).executions(Integer.valueOf(request.getExecutions())).message(request.getMessage()).retries(Integer.valueOf(request.getRetries())).scheduledDate(request.getTime()).status(request.getStatus().toString()).containerId(request.getDeploymentId());
        if (withErrors) {
            ErrorInfoInstance[] errors = new ErrorInfoInstance[request.getErrorInfo().size()];
            int index = 0;
            for (ErrorInfo error : request.getErrorInfo()) {
                errors[index] = ErrorInfoInstance.builder().id(error.getId()).errorDate(error.getTime()).message(error.getMessage()).requestId(request.getId()).stacktrace(error.getStacktrace()).build();
                ++index;
            }
            builder.errors(new ErrorInfoInstanceList(errors));
        }
        if (withData) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String deploymentId = ((RequestInfo)request).getDeploymentId();
            if (deploymentId != null && this.context.getContainer(deploymentId) != null) {
                KieContainerInstanceImpl containerInstance = this.context.getContainer(deploymentId);
                classLoader = containerInstance.getKieContainer().getClassLoader();
            }
            builder.data(this.readContent(request.getRequestData(), classLoader));
            builder.responseData(this.readContent(request.getResponseData(), classLoader));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> readContent(byte[] data, ClassLoader classLoader) {
        Object result = null;
        if (data != null) {
            ObjectInputStream in = null;
            try {
                in = new ClassLoaderObjectInputStream(classLoader, (InputStream)new ByteArrayInputStream(data));
                result = in.readObject();
            }
            catch (Exception e) {
                logger.warn("Exception while serializing context data", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (result instanceof CommandContext) {
                return ((CommandContext)result).getData();
            }
            if (result instanceof ExecutionResults) {
                return ((ExecutionResults)result).getData();
            }
        }
        return new HashMap<String, Object>();
    }

    protected QueryContext buildQueryContext(Integer page, Integer pageSize) {
        return new QueryContext(Integer.valueOf(page * pageSize), pageSize);
    }

    protected boolean validateCommand(String command, ClassLoader classLoader) {
        try {
            Class.forName(command, true, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected List<STATUS> convertStatusList(List<String> statuses) {
        ArrayList<STATUS> statusList = new ArrayList<STATUS>();
        if (statuses != null && !statuses.isEmpty()) {
            for (String status : statuses) {
                statusList.add(STATUS.valueOf((String)status));
            }
        } else {
            statusList.add(STATUS.QUEUED);
        }
        return statusList;
    }
}

