/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl.quartz;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.jbpm.process.core.timer.impl.quartz.QuartzUtils;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class DeploymentsAwareStdJDBCDelegate
extends StdJDBCDelegate {
    private QuartzUtils quartzUtils = new QuartzUtils();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TriggerKey> selectTriggerToAcquire(Connection conn, long noLaterThan, long noEarlierThan, int maxCount) throws SQLException {
        LinkedList<TriggerKey> linkedList;
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<TriggerKey> nextTriggers = new LinkedList<TriggerKey>();
        try {
            List<String> deploymentIds = this.quartzUtils.getDeployments();
            ps = conn.prepareStatement(this.rtp(this.quartzUtils.nextTriggerQuery(deploymentIds)));
            if (maxCount < 1) {
                maxCount = 1;
            }
            ps.setMaxRows(maxCount);
            ps.setFetchSize(maxCount);
            ps.setString(1, "WAITING");
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(noLaterThan)));
            ps.setBigDecimal(3, new BigDecimal(String.valueOf(noEarlierThan)));
            int index = 4;
            for (String deployment : deploymentIds) {
                ps.setString(index++, deployment);
            }
            rs = ps.executeQuery();
            while (rs.next() && nextTriggers.size() <= maxCount) {
                nextTriggers.add(TriggerKey.triggerKey((String)rs.getString("TRIGGER_NAME"), (String)rs.getString("TRIGGER_GROUP")));
            }
            linkedList = nextTriggers;
        }
        catch (Throwable throwable) {
            DeploymentsAwareStdJDBCDelegate.closeResultSet(rs);
            DeploymentsAwareStdJDBCDelegate.closeStatement(ps);
            throw throwable;
        }
        DeploymentsAwareStdJDBCDelegate.closeResultSet((ResultSet)rs);
        DeploymentsAwareStdJDBCDelegate.closeStatement((Statement)ps);
        return linkedList;
    }

    public int countMisfiredTriggersInState(Connection conn, String state1, long ts) throws SQLException {
        block4: {
            int n;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                List<String> deploymentIds = this.quartzUtils.getDeployments();
                ps = conn.prepareStatement(this.rtp(this.quartzUtils.countMisfiredTriggersQuery(deploymentIds)));
                ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
                ps.setString(2, state1);
                int index = 3;
                for (String deployment : deploymentIds) {
                    ps.setString(index++, deployment);
                }
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DeploymentsAwareStdJDBCDelegate.closeResultSet(rs);
                DeploymentsAwareStdJDBCDelegate.closeStatement(ps);
                throw throwable;
            }
            DeploymentsAwareStdJDBCDelegate.closeResultSet((ResultSet)rs);
            DeploymentsAwareStdJDBCDelegate.closeStatement((Statement)ps);
            return n;
        }
        throw new SQLException("No misfired trigger count returned.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TriggerKey> selectMisfiredTriggersInState(Connection conn, String state, long ts) throws SQLException {
        LinkedList<TriggerKey> linkedList;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            List<String> deploymentIds = this.quartzUtils.getDeployments();
            ps = conn.prepareStatement(this.rtp(this.quartzUtils.misfiredTriggersQuery(deploymentIds)));
            ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
            ps.setString(2, state);
            int index = 3;
            for (String deployment : deploymentIds) {
                ps.setString(index++, deployment);
            }
            rs = ps.executeQuery();
            LinkedList<TriggerKey> list = new LinkedList<TriggerKey>();
            while (rs.next()) {
                String triggerName = rs.getString("TRIGGER_NAME");
                String groupName = rs.getString("TRIGGER_GROUP");
                list.add(TriggerKey.triggerKey((String)triggerName, (String)groupName));
            }
            linkedList = list;
        }
        catch (Throwable throwable) {
            DeploymentsAwareStdJDBCDelegate.closeResultSet(rs);
            DeploymentsAwareStdJDBCDelegate.closeStatement(ps);
            throw throwable;
        }
        DeploymentsAwareStdJDBCDelegate.closeResultSet((ResultSet)rs);
        DeploymentsAwareStdJDBCDelegate.closeStatement((Statement)ps);
        return linkedList;
    }
}

