/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.List;
import java.util.Map;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.kiescanner.KieScannerEventListener;
import org.kie.api.event.kiescanner.KieScannerStatusChangeEvent;
import org.kie.api.event.kiescanner.KieScannerUpdateResultsEvent;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerScannerEventListener
implements KieScannerEventListener {
    private static final Logger logger = LoggerFactory.getLogger(KieServerScannerEventListener.class);
    private KieServerImpl kieServer;
    private KieContainerInstanceImpl kieContainerInstance;

    public KieServerScannerEventListener(KieServerImpl kieServer, KieContainerInstanceImpl kieContainerInstance) {
        this.kieServer = kieServer;
        this.kieContainerInstance = kieContainerInstance;
    }

    public void onKieScannerStatusChangeEvent(KieScannerStatusChangeEvent statusChange) {
    }

    public void onKieScannerUpdateResultsEvent(KieScannerUpdateResultsEvent updateResults) {
        if (!updateResults.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            List<KieServerExtension> extensions = this.kieServer.getServerExtensions();
            String containerId = this.kieContainerInstance.getContainerId();
            ReleaseId releaseId = this.kieContainerInstance.getKieContainer().getContainerReleaseId();
            Map<String, Object> parameters = this.kieServer.getContainerParameters(releaseId, this.kieServer.getMessagesForContainer(containerId));
            for (KieServerExtension extension : extensions) {
                boolean allowed = extension.isUpdateContainerAllowed(containerId, this.kieContainerInstance, parameters);
                if (allowed) continue;
                logger.error("Unable to update container {} due to it is not allowed by extension {}", (Object)containerId, (Object)extension);
                return;
            }
            this.kieContainerInstance.clearExtraClasses();
            boolean disposedMarshallers = this.kieContainerInstance.updateReleaseId();
            if (!disposedMarshallers) {
                this.kieContainerInstance.disposeMarshallers();
            }
            for (KieServerExtension extension : extensions) {
                extension.updateContainer(containerId, this.kieContainerInstance, parameters);
                logger.debug("Container {} (for release id {}) on {} updated successfully", new Object[]{containerId, releaseId, extension});
            }
        }
    }
}

