/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.storage.file;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.impl.KieServerContainerDeployment;
import org.kie.server.services.impl.StartupStrategyProvider;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.KieServerStateRepositoryUtils;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerStateFileInit {
    private static final Logger logger = LoggerFactory.getLogger(KieServerStateFileInit.class);
    private static final ServiceLoader<KieServerStateRepository> serverStateRepos = ServiceLoader.load(KieServerStateRepository.class);

    private KieServerStateFileInit() {
    }

    public static void main(String ... args) {
        File serverStateFile = KieServerStateFileInit.init();
        logger.info("Initialized kie server state file: {}", (Object)serverStateFile);
    }

    public static File init() {
        String serverId = KieServerStateRepositoryUtils.getServerId();
        String serverRepoType = StartupStrategyProvider.get().getStrategy().getRepositoryType();
        KieServerEnvironment.setServerId((String)serverId);
        KieServerEnvironment.setServerName((String)serverId);
        KieServerStateRepository repository = null;
        File serverStateFile = KieServerStateRepositoryUtils.getStateFile();
        for (KieServerStateRepository repo : serverStateRepos) {
            if (!repo.getClass().getSimpleName().equals(serverRepoType)) continue;
            repository = repo;
            break;
        }
        if (repository == null) {
            repository = new KieServerStateFileRepository(KieServerStateRepositoryUtils.getFileRepoDir());
            logger.warn("ServiceLoader failed to initiate kie server repository: {}, fall back to KieServerStateFileRepository.", (Object)serverRepoType);
        } else {
            logger.info("Initialized with '{}' kie server repository", (Object)serverRepoType);
        }
        if ("KieServerStateFileRepository".equals(serverRepoType) && serverStateFile.exists()) {
            throw new IllegalStateException(String.format("%s already exists. %s should only be used for pre-bootstrapping creation of server state file.", serverStateFile, KieServerStateFileInit.class.getSimpleName()));
        }
        KieServerState serverState = new KieServerState();
        KieServerConfig config = new KieServerConfig();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.put("org.kie.server.repo", KieServerStateRepositoryUtils.getFileRepoPath());
        properties.put("org.kie.server.id", serverId);
        properties.put("org.kie.server.state.immutable", "true");
        KieServerStateRepositoryUtils.populateWithProperties(config, properties);
        System.setProperty("org.kie.server.state.immutable.init", "true");
        serverState.setConfiguration(config);
        LinkedHashSet<KieContainerResource> containers = new LinkedHashSet<KieContainerResource>();
        String serverContainerDeployment = KieServerStateRepositoryUtils.getValue("org.kie.server.container.deployment", "KIE_SERVER_CONTAINER_DEPLOYMENT", null);
        Set<KieServerContainerDeployment> deployments = KieServerContainerDeployment.fromString(serverContainerDeployment);
        for (KieServerContainerDeployment deployment : deployments) {
            KieContainerResource container = new KieContainerResource(deployment.getContainerId(), new ReleaseId(deployment.getReleaseId()), KieContainerStatus.STARTED);
            container.setContainerAlias(deployment.getContainerAlias());
            containers.add(container);
        }
        serverState.setContainers(containers);
        repository.store(serverId, serverState);
        return serverStateFile;
    }
}

