/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.runtime.command;

import java.util.Date;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.kie.api.runtime.Context;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.server.api.model.taskassigning.PlanningItem;
import org.kie.server.services.taskassigning.runtime.persistence.PlanningTaskImpl;

public abstract class PlanningCommand
extends TaskCommand {
    protected PlanningItem planningItem;
    protected TaskContext taskContext;
    protected TaskPersistenceContext persistenceContext;

    public PlanningCommand(PlanningItem planningItem) {
        this.planningItem = planningItem;
    }

    public Object execute(Context context) {
        this.taskContext = (TaskContext)context;
        this.persistenceContext = this.taskContext.getPersistenceContext();
        return null;
    }

    public PlanningItem getPlanningItem() {
        return this.planningItem;
    }

    protected void saveOrUpdatePlanningTask(PlanningItem planningItem) {
        PlanningTaskImpl planningTask = (PlanningTaskImpl)this.persistenceContext.find(PlanningTaskImpl.class, (Object)planningItem.getTaskId());
        if (planningTask != null) {
            planningTask.setAssignedUser(planningItem.getPlanningTask().getAssignedUser());
            planningTask.setIndex(planningItem.getPlanningTask().getIndex());
            planningTask.setPublished(planningItem.getPlanningTask().isPublished());
            planningTask.setLastModificationDate(new Date());
            this.persistenceContext.merge((Object)planningTask);
        } else {
            planningTask = new PlanningTaskImpl(planningItem.getTaskId(), planningItem.getPlanningTask().getAssignedUser(), planningItem.getPlanningTask().getIndex(), planningItem.getPlanningTask().isPublished(), new Date());
            this.persistenceContext.persist((Object)planningTask);
        }
    }
}

