/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.client.handlers;

import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandScriptMessageHandler
implements InternalMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(CommandScriptMessageHandler.class);
    private static final String TARGET_CAPABILITY = "KieServer";
    private KieServerRegistry context;

    public CommandScriptMessageHandler(KieServerRegistry context) {
        this.context = context;
    }

    public String onMessage(String message) {
        CommandScript script = (CommandScript)this.deserialize(message, CommandScript.class);
        String capability = TARGET_CAPABILITY;
        boolean hasBPMCommand = script.getCommands().stream().anyMatch(cmd -> cmd instanceof DescriptorCommand);
        if (hasBPMCommand) {
            capability = "BPM";
        }
        KieContainerCommandService executor = null;
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            KieContainerCommandService tmp = (KieContainerCommandService)extension.getAppComponents(KieContainerCommandService.class);
            if (tmp == null || !extension.getImplementedCapability().equalsIgnoreCase(capability)) continue;
            executor = tmp;
            logger.debug("Extension {} returned command executor {} with capability {}", new Object[]{extension, executor, extension.getImplementedCapability()});
            break;
        }
        if (executor == null) {
            throw new IllegalStateException("No executor found for script execution");
        }
        ServiceResponsesList response = executor.executeScript(script, MarshallingFormat.JSON, null);
        String reply = this.serialize(response);
        return reply;
    }

    public InternalMessageHandler getNextHandler() {
        return this;
    }
}

