/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.api.admin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jbpm.services.api.admin.MigrationReport;

public class CaseMigrationReport {
    private boolean successful = false;
    private Date startDate;
    private Date endDate;
    private List<MigrationReport> reports = new ArrayList<MigrationReport>();

    public CaseMigrationReport() {
        this.startDate = new Date();
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public List<MigrationReport> getReports() {
        return this.reports;
    }

    public void addReport(MigrationReport report) {
        this.reports.add(report);
    }

    public void complete() {
        this.endDate = new Date();
        if (this.reports.stream().allMatch(report -> report.isSuccessful())) {
            this.successful = true;
        }
    }

    public String toString() {
        return "CaseMigrationReport [successful=" + this.successful + ", startDate=" + this.startDate + ", endDate=" + this.endDate + "]";
    }
}

