/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.internal.identity.IdentityProvider;

public class IdentityProviderAwareProcessListener
extends DefaultProcessEventListener {
    private KieSession kieSession;
    private IdentityProvider identityProvider;

    public IdentityProviderAwareProcessListener(KieSession kieSession) {
        this.kieSession = kieSession;
    }

    protected void resolveIdentityProvider() {
        if (this.identityProvider != null) {
            return;
        }
        Object identityProvider = this.kieSession.getEnvironment().get("IdentityProvider");
        if (identityProvider instanceof IdentityProvider) {
            this.identityProvider = (IdentityProvider)identityProvider;
        }
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        this.resolveIdentityProvider();
        if (this.identityProvider != null) {
            WorkflowProcessInstance wpi = (WorkflowProcessInstance)event.getProcessInstance();
            String name = this.identityProvider.getName();
            wpi.setVariable("initiator", (Object)name);
            wpi.getMetaData().put("OwnerId", name);
        }
    }
}

