/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalContent;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;

public class UpdateTaskCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1856489382099976731L;
    private UserTaskInstanceDesc userTask;
    private Map<String, Object> inputs;
    private Map<String, Object> outputs;

    public UpdateTaskCommand(Long taskId, String userId, UserTaskInstanceDesc userTask, Map<String, Object> inputs, Map<String, Object> outputs) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.userTask = userTask;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        TaskEventSupport taskEventSupport = context.getTaskEventSupport();
        TaskPersistenceContext persistenceContext = context.getPersistenceContext();
        Task task = persistenceContext.findTask(this.taskId);
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (org.kie.internal.task.api.TaskContext)context) && !this.isOwner(this.userId, task.getPeopleAssignments().getPotentialOwners(), (OrganizationalEntity)task.getTaskData().getActualOwner(), context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin or potential owner of task " + this.taskId);
        }
        taskEventSupport.fireBeforeTaskUpdated(task, (org.kie.internal.task.api.TaskContext)context);
        if (this.userTask.getFormName() != null) {
            ((InternalTask)task).setFormName(this.userTask.getFormName());
        }
        if (this.userTask.getName() != null) {
            ((InternalTask)task).setName(this.userTask.getName());
        }
        if (this.userTask.getDescription() != null) {
            ((InternalTask)task).setDescription(this.userTask.getDescription());
        }
        if (this.userTask.getPriority() != null) {
            ((InternalTask)task).setPriority(this.userTask.getPriority());
        }
        if (this.userTask.getDueDate() != null) {
            ((InternalTaskData)task.getTaskData()).setExpirationTime(this.userTask.getDueDate());
        }
        long inputContentId = task.getTaskData().getDocumentContentId();
        Content inputContent = persistenceContext.findContent(Long.valueOf(inputContentId));
        Map mergedContent = this.inputs;
        if (this.inputs != null) {
            if (inputContent == null) {
                ContentMarshallerContext mcontext = context.getTaskContentService().getMarshallerContext(task);
                ContentData outputContentData = ContentMarshallerHelper.marshal((Task)task, this.inputs, (Environment)mcontext.getEnvironment());
                Content content = TaskModelProvider.getFactory().newContent();
                ((InternalContent)content).setContent(outputContentData.getContent());
                persistenceContext.persistContent(content);
                ((InternalTaskData)task.getTaskData()).setOutput(content.getId().longValue(), outputContentData);
            } else {
                ContentMarshallerContext mcontext = context.getTaskContentService().getMarshallerContext(task);
                Object unmarshalledObject = ContentMarshallerHelper.unmarshall((byte[])inputContent.getContent(), (Environment)mcontext.getEnvironment(), (ClassLoader)mcontext.getClassloader());
                if (unmarshalledObject != null && unmarshalledObject instanceof Map) {
                    ((Map)unmarshalledObject).putAll(this.inputs);
                    mergedContent = (Map)unmarshalledObject;
                }
                ContentData outputContentData = ContentMarshallerHelper.marshal((Task)task, (Object)unmarshalledObject, (Environment)mcontext.getEnvironment());
                ((InternalContent)inputContent).setContent(outputContentData.getContent());
                persistenceContext.persistContent(inputContent);
            }
            ((InternalTaskData)task.getTaskData()).setTaskInputVariables(mergedContent);
        }
        if (this.outputs != null) {
            context.getTaskContentService().addOutputContent(this.taskId.longValue(), this.outputs);
        }
        persistenceContext.updateTask(task);
        taskEventSupport.fireAfterTaskUpdated(task, (org.kie.internal.task.api.TaskContext)context);
        return null;
    }

    protected boolean isOwner(String userId, List<OrganizationalEntity> potentialOwners, OrganizationalEntity actualOwner, TaskContext context) {
        boolean isOwner;
        ArrayList<String> usersGroup = new ArrayList<String>(context.getUserGroupCallback().getGroupsForUser(userId));
        usersGroup.add(userId);
        if (actualOwner != null && (isOwner = userId.equals(actualOwner.getId()))) {
            return true;
        }
        return potentialOwners.stream().anyMatch(oe -> usersGroup.contains(oe.getId()));
    }
}

