/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.json;

import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonException;
import org.dashbuilder.json.JsonFactory;
import org.dashbuilder.json.JsonNumber;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonValue;

class JsonTokenizer {
    private static final int INVALID_CHAR = -1;
    private static final String STOPCHARS = ",:]}/\\\"[{;=#";
    private JsonFactory jsonFactory;
    private boolean lenient = true;
    private int pushBackBuffer = -1;
    private final String json;
    private int position = 0;

    JsonTokenizer(JsonFactory serverJsonFactory, String json) {
        this.jsonFactory = serverJsonFactory;
        this.json = json;
    }

    void back(char c) {
        assert (this.pushBackBuffer == -1);
        this.pushBackBuffer = c;
    }

    void back(int c) {
        this.back((char)c);
    }

    int next() {
        if (this.pushBackBuffer != -1) {
            int c = this.pushBackBuffer;
            this.pushBackBuffer = -1;
            return c;
        }
        return this.position < this.json.length() ? (int)this.json.charAt(this.position++) : -1;
    }

    String next(int n) throws JsonException {
        int len;
        if (n == 0) {
            return "";
        }
        char[] buffer = new char[n];
        int pos = 0;
        if (this.pushBackBuffer != -1) {
            buffer[0] = (char)this.pushBackBuffer;
            pos = 1;
            this.pushBackBuffer = -1;
        }
        while (pos < n && (len = this.read(buffer, pos, n - pos)) != -1) {
            pos += len;
        }
        if (pos < n) {
            throw new JsonException("Position " + pos + " less than " + n);
        }
        return String.valueOf(buffer);
    }

    int nextNonWhitespace() {
        int c;
        while (Character.isWhitespace((char)(c = this.next()))) {
        }
        return c;
    }

    String nextString(int startChar) throws JsonException {
        StringBuilder buffer = new StringBuilder();
        int c = this.next();
        assert (c == 34 || this.lenient && c == 39);
        block12: while (true) {
            c = this.next();
            switch (c) {
                case 10: 
                case 13: {
                    throw new JsonException("");
                }
                case 92: {
                    c = this.next();
                    switch (c) {
                        case 98: {
                            buffer.append('\b');
                            continue block12;
                        }
                        case 116: {
                            buffer.append('\t');
                            continue block12;
                        }
                        case 110: {
                            buffer.append('\n');
                            continue block12;
                        }
                        case 102: {
                            buffer.append('\f');
                            continue block12;
                        }
                        case 114: {
                            buffer.append('\r');
                            continue block12;
                        }
                        case 117: {
                            buffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block12;
                        }
                    }
                    buffer.append((char)c);
                    continue block12;
                }
            }
            if (c == startChar) {
                return buffer.toString();
            }
            buffer.append((char)c);
        }
    }

    String nextUntilOneOf(String chars) {
        StringBuilder buffer = new StringBuilder();
        int c = this.next();
        while (c != -1) {
            if (Character.isWhitespace((char)c) || chars.indexOf((char)c) >= 0) {
                this.back(c);
                break;
            }
            buffer.append((char)c);
            c = this.next();
        }
        return buffer.toString();
    }

    <T extends JsonValue> T nextValue() throws JsonException {
        int c = this.nextNonWhitespace();
        this.back(c);
        switch (c) {
            case 34: 
            case 39: {
                return (T)this.jsonFactory.create(this.nextString(c));
            }
            case 123: {
                return (T)this.parseObject();
            }
            case 91: {
                return (T)this.parseArray();
            }
        }
        return (T)this.getValueForLiteral(this.nextUntilOneOf(STOPCHARS));
    }

    JsonArray parseArray() throws JsonException {
        JsonArray array = this.jsonFactory.createArray();
        int c = this.nextNonWhitespace();
        assert (c == 91);
        block7: while (true) {
            c = this.nextNonWhitespace();
            switch (c) {
                case 93: {
                    return array;
                }
            }
            this.back(c);
            array.set(array.length(), (JsonValue)this.nextValue());
            int d = this.nextNonWhitespace();
            switch (d) {
                case 93: {
                    return array;
                }
                case 44: {
                    continue block7;
                }
            }
            break;
        }
        throw new JsonException("Invalid array: expected , or ]");
    }

    JsonObject parseObject() throws JsonException {
        block18: {
            JsonObject object = this.jsonFactory.createObject();
            int c = this.nextNonWhitespace();
            if (c != 123) {
                throw new JsonException("Payload does not begin with '{'.  Got " + c + "(" + Character.valueOf((char)c) + ")");
            }
            block13: while (true) {
                c = this.nextNonWhitespace();
                switch (c) {
                    case 125: {
                        return object;
                    }
                    case 34: 
                    case 39: {
                        this.back(c);
                        String key = this.nextString(c);
                        if (this.nextNonWhitespace() != 58) {
                            throw new JsonException("Invalid object: expecting \":\"");
                        }
                        object.put(key, (JsonValue)this.nextValue());
                        switch (this.nextNonWhitespace()) {
                            case 44: {
                                continue block13;
                            }
                            case 125: {
                                return object;
                            }
                        }
                        throw new JsonException("Invalid object: expecting } or ,");
                    }
                    case 44: {
                        continue block13;
                    }
                }
                if (!this.lenient || !Character.isDigit((char)c) && !Character.isLetterOrDigit((char)c)) break block18;
                StringBuilder keyBuffer = new StringBuilder();
                keyBuffer.append(c);
                while (Character.isDigit((char)(c = this.next())) || Character.isLetterOrDigit((char)c)) {
                    keyBuffer.append(c);
                }
                this.back(c);
                if (this.nextNonWhitespace() != 58) {
                    throw new JsonException("Invalid object: expecting \":\"");
                }
                object.put(keyBuffer.toString(), (JsonValue)this.nextValue());
                switch (this.nextNonWhitespace()) {
                    case 44: {
                        continue block13;
                    }
                    case 125: {
                        return object;
                    }
                }
                break;
            }
            throw new JsonException("Invalid object: expecting } or ,");
        }
        throw new JsonException("Invalid object: ");
    }

    private JsonNumber getNumberForLiteral(String literal) throws JsonException {
        try {
            return this.jsonFactory.create(Double.parseDouble(literal));
        }
        catch (NumberFormatException e) {
            throw new JsonException("Invalid number literal: " + literal);
        }
    }

    private JsonValue getValueForLiteral(String literal) throws JsonException {
        if ("".equals(literal)) {
            throw new JsonException("Missing value");
        }
        if ("null".equals(literal) || "undefined".equals(literal)) {
            return this.jsonFactory.createNull();
        }
        if ("true".equals(literal)) {
            return this.jsonFactory.create(true);
        }
        if ("false".equals(literal)) {
            return this.jsonFactory.create(false);
        }
        char c = literal.charAt(0);
        if (c == '-' || Character.isDigit(c)) {
            return this.getNumberForLiteral(literal);
        }
        throw new JsonException("Invalid literal: \"" + literal + "\"");
    }

    private int read(char[] buffer, int pos, int len) {
        int maxLen = Math.min(this.json.length() - this.position, len);
        String src = this.json.substring(this.position, this.position + maxLen);
        char[] result = src.toCharArray();
        System.arraycopy(result, 0, buffer, pos, maxLen);
        this.position += maxLen;
        return maxLen;
    }
}

