/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.compilers;

import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.kie.internal.jci.CompilationProblem;

public class NativeCompilationProblem
implements CompilationProblem {
    private final Diagnostic<JavaFileObject> problem;

    public NativeCompilationProblem(Diagnostic<JavaFileObject> problem) {
        this.problem = problem;
    }

    public boolean isError() {
        return this.problem.getKind() == Diagnostic.Kind.ERROR;
    }

    public String getFileName() {
        return this.problem.getSource() == null ? "UNKNOWN" : this.problem.getSource().getName().substring(1);
    }

    public int getStartLine() {
        return (int)this.problem.getLineNumber();
    }

    public int getStartColumn() {
        return (int)this.problem.getColumnNumber();
    }

    public int getEndLine() {
        return (int)this.problem.getLineNumber();
    }

    public int getEndColumn() {
        return (int)this.problem.getColumnNumber();
    }

    public String getMessage() {
        return this.problem.getMessage(null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFileName()).append(" (");
        sb.append(this.getStartLine());
        sb.append(":");
        sb.append(this.getStartColumn());
        sb.append(") : ");
        sb.append(this.getMessage());
        return sb.toString();
    }
}

