/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch.scope;

import java.util.List;
import java.util.SortedSet;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class ExhaustiveSearchPhaseScope<Solution_>
extends AbstractPhaseScope<Solution_> {
    private List<ExhaustiveSearchLayer> layerList;
    private SortedSet<ExhaustiveSearchNode> expandableNodeQueue;
    private Score bestPessimisticBound;
    private ExhaustiveSearchStepScope<Solution_> lastCompletedStepScope = new ExhaustiveSearchStepScope(this, -1);

    public ExhaustiveSearchPhaseScope(DefaultSolverScope<Solution_> solverScope) {
        super(solverScope);
    }

    public List<ExhaustiveSearchLayer> getLayerList() {
        return this.layerList;
    }

    public void setLayerList(List<ExhaustiveSearchLayer> layerList) {
        this.layerList = layerList;
    }

    public SortedSet<ExhaustiveSearchNode> getExpandableNodeQueue() {
        return this.expandableNodeQueue;
    }

    public void setExpandableNodeQueue(SortedSet<ExhaustiveSearchNode> expandableNodeQueue) {
        this.expandableNodeQueue = expandableNodeQueue;
    }

    public Score getBestPessimisticBound() {
        return this.bestPessimisticBound;
    }

    public void setBestPessimisticBound(Score bestPessimisticBound) {
        this.bestPessimisticBound = bestPessimisticBound;
    }

    @Override
    public ExhaustiveSearchStepScope<Solution_> getLastCompletedStepScope() {
        return this.lastCompletedStepScope;
    }

    public void setLastCompletedStepScope(ExhaustiveSearchStepScope<Solution_> lastCompletedStepScope) {
        this.lastCompletedStepScope = lastCompletedStepScope;
    }

    public int getDepthSize() {
        return this.layerList.size();
    }

    public void registerPessimisticBound(Score pessimisticBound) {
        if (pessimisticBound.compareTo(this.bestPessimisticBound) > 0) {
            this.bestPessimisticBound = pessimisticBound;
            this.expandableNodeQueue.removeIf(node -> node.getOptimisticBound().compareTo(this.bestPessimisticBound) <= 0);
        }
    }

    public void addExpandableNode(ExhaustiveSearchNode moveNode) {
        this.expandableNodeQueue.add(moveNode);
        moveNode.setExpandable(true);
    }
}

