/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.common;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetScoringNode;

public class BavetNodeBuildPolicy<Solution_> {
    private final BavetConstraintSession session;
    private int nodeOrderMaximum = 0;
    private Map<String, BavetScoringNode> constraintIdToScoringNodeMap;
    private Map<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode> joinConstraintStreamToJoinBridgeNodeMap = new HashMap<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode>();
    private Map<BavetAbstractNode, BavetAbstractNode> sharableNodeMap = new HashMap<BavetAbstractNode, BavetAbstractNode>();

    public BavetNodeBuildPolicy(BavetConstraintSession session, int constraintCount) {
        this.session = session;
        this.constraintIdToScoringNodeMap = new LinkedHashMap<String, BavetScoringNode>(constraintCount);
    }

    public void updateNodeOrderMaximum(int nodeOrder) {
        if (this.nodeOrderMaximum < nodeOrder) {
            this.nodeOrderMaximum = nodeOrder;
        }
    }

    public <Node_ extends BavetAbstractNode> Node_ retrieveSharedNode(Node_ node) {
        BavetAbstractNode sharedNode = this.sharableNodeMap.computeIfAbsent(node, k -> node);
        if (node.getNodeOrder() != sharedNode.getNodeOrder()) {
            throw new IllegalStateException("Impossible state: the node (" + node + ")'s nodeOrder (" + node.getNodeOrder() + ") differs from the sharedNode (" + sharedNode + ")'s nodeOrder (" + sharedNode.getNodeOrder() + ").");
        }
        return (Node_)sharedNode;
    }

    public void addScoringNode(BavetScoringNode scoringNode) {
        this.constraintIdToScoringNodeMap.put(scoringNode.getConstraintId(), scoringNode);
    }

    public BavetConstraintSession getSession() {
        return this.session;
    }

    public int getNodeOrderMaximum() {
        return this.nodeOrderMaximum;
    }

    public Map<String, BavetScoringNode> getConstraintIdToScoringNodeMap() {
        return this.constraintIdToScoringNodeMap;
    }

    public Map<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode> getJoinConstraintStreamToJoinBridgeNodeMap() {
        return this.joinConstraintStreamToJoinBridgeNodeMap;
    }
}

