/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.xstream;

import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.util.HashSet;
import java.util.Set;
import org.kie.internal.utils.KieTypeResolver;

public class KieServerTypePermission
extends WildcardTypePermission {
    private static final String[] WHITELISTED_PACKAGES = new String[]{"org.kie.server.api.model.**", "org.dashbuilder.dataset.filter.**", "org.dashbuilder.dataset.group.**", "org.dashbuilder.dataset.sort.**", "org.drools.core.process.instance.impl.WorkItemImpl", "org.jbpm.document.**"};
    private final Set<Class<?>> classes;

    public KieServerTypePermission(Set<Class<?>> classes) {
        super(KieServerTypePermission.patterns());
        this.classes = classes == null ? new HashSet() : classes;
    }

    public boolean allows(Class type) {
        boolean allowed = super.allows(type);
        if (!allowed && !(allowed = this.classes.contains(type)) && type.getClassLoader() instanceof KieTypeResolver) {
            allowed = true;
        }
        return allowed;
    }

    protected static String[] patterns() {
        String packageList = System.getProperty("org.kie.server.xstream.enabled.packages");
        String[] filter = new String[]{};
        if (packageList != null) {
            filter = packageList.split(",");
        }
        String[] patterns = new String[WHITELISTED_PACKAGES.length + filter.length];
        System.arraycopy(filter, 0, patterns, 0, filter.length);
        System.arraycopy(WHITELISTED_PACKAGES, 0, patterns, filter.length, WHITELISTED_PACKAGES.length);
        return patterns;
    }
}

