/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.definition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.api.util.QueryFilterSpecBuilder;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="query-filter-spec")
public class QueryFilterSpec {
    @XmlElement(name="order-by")
    private String orderBy;
    @XmlElement(name="order-asc")
    private boolean ascending;
    @XmlElement(name="query-params")
    private QueryParam[] parameters;
    @XmlElement(name="result-column-mapping")
    private Map<String, String> columnMapping;
    @XmlElement(name="order-by-clause")
    private String orderByClause;

    public static QueryFilterSpecBuilder builder() {
        return new QueryFilterSpecBuilder();
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public QueryParam[] getParameters() {
        return this.parameters;
    }

    public void setParameters(QueryParam[] parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getColumnMapping() {
        return this.columnMapping;
    }

    public void setColumnMapping(Map<String, String> columnMapping) {
        this.columnMapping = columnMapping;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String toString() {
        return "QueryFilterSpec{orderBy='" + this.orderBy + '\'' + ", ascending=" + this.ascending + ", parameters=" + Arrays.toString(this.parameters) + '}';
    }

    protected void unwrapParameters() {
        if (this.parameters == null) {
            return;
        }
        for (QueryParam param : this.parameters) {
            if (param.getValue() == null) continue;
            ArrayList items = new ArrayList();
            param.getValue().forEach(item -> {
                Object toAdd = item;
                if (item instanceof Wrapped) {
                    toAdd = ((Wrapped)item).unwrap();
                }
                items.add(toAdd);
            });
            param.setValue(items);
        }
    }
}

