/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver.realtime;

import java.util.List;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.User;
import org.kie.server.services.taskassigning.core.model.solver.TaskHelper;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ProblemFactChangeUtil {
    private ProblemFactChangeUtil() {
    }

    public static void releaseAllTasks(User workingUser, ScoreDirector<TaskAssigningSolution> scoreDirector) {
        ProblemFactChangeUtil.releaseTasks(workingUser, true, scoreDirector);
    }

    public static void releaseNonPinnedTasks(User workingUser, ScoreDirector<TaskAssigningSolution> scoreDirector) {
        ProblemFactChangeUtil.releaseTasks(workingUser, false, scoreDirector);
    }

    private static void releaseTasks(User workingUser, boolean includePinnedTasks, ScoreDirector<TaskAssigningSolution> scoreDirector) {
        List<Task> tasks = TaskHelper.extractTasks(workingUser, testedTask -> includePinnedTasks || !testedTask.isPinned());
        for (int index = tasks.size() - 1; index >= 0; --index) {
            Task task = tasks.get(index);
            scoreDirector.beforeProblemPropertyChanged((Object)task);
            task.setPinned(false);
            scoreDirector.afterProblemPropertyChanged((Object)task);
            scoreDirector.beforeVariableChanged((Object)task, "previousTaskOrUser");
            task.setPreviousTaskOrUser(null);
            scoreDirector.afterVariableChanged((Object)task, "previousTaskOrUser");
        }
    }
}

